/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rawstore;

import com.bigdata.rawstore.IAddressManager;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rawstore.IRawStore;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public abstract class AbstractRawStore
implements IRawStore {
    static final int WORM_STREAM_BUFFER_SIZE = 16384;

    public abstract IAddressManager getAddressManager();

    @Override
    public void delete(long addr) {
    }

    @Override
    public IPSOutputStream getOutputStream() {
        return new WORMOutputStream();
    }

    @Override
    public InputStream getInputStream(long addr) {
        return new WORMInputStream(addr);
    }

    class WORMInputStream
    extends InputStream {
        private final ByteBuffer m_hbb;
        private ByteBuffer m_bb;

        WORMInputStream(long stream_addr) {
            boolean isStream = stream_addr < 0L;
            long addr = isStream ? -stream_addr : stream_addr;
            IAddressManager am = AbstractRawStore.this.getAddressManager();
            int nbytes = am.getByteCount(addr);
            if (isStream && nbytes != 0 && nbytes < 16384) {
                throw new IllegalArgumentException("Stream Address for unexpected data length: " + nbytes);
            }
            if (isStream) {
                int nblocks = (nbytes + 16383) / 16384;
                this.m_hbb = AbstractRawStore.this.read(am.toAddr(nblocks * 8, am.getOffset(addr)));
                assert (this.m_hbb.hasRemaining());
                this.m_bb = AbstractRawStore.this.read(this.m_hbb.getLong());
            } else {
                this.m_hbb = null;
                this.m_bb = nbytes > 0 ? AbstractRawStore.this.read(addr) : ByteBuffer.allocate(0);
            }
        }

        @Override
        public int read() throws IOException {
            if (!this.m_bb.hasRemaining() && this.m_hbb != null && this.m_hbb.hasRemaining()) {
                this.m_bb = AbstractRawStore.this.read(this.m_hbb.getLong());
            }
            if (!this.m_bb.hasRemaining()) {
                return -1;
            }
            return 0xFF & this.m_bb.get();
        }

        @Override
        public synchronized int read(byte[] dst, int off, int len) throws IOException {
            if (this.m_bb.remaining() >= len) {
                this.m_bb.get(dst, off, len);
                return len;
            }
            int cursor = 0;
            int len1 = this.m_bb.remaining();
            this.m_bb.get(dst, off, len1);
            cursor += len1;
            while (this.m_hbb != null && this.m_hbb.hasRemaining()) {
                this.m_bb = AbstractRawStore.this.read(this.m_hbb.getLong());
                int len2 = len - cursor;
                if (this.m_bb.remaining() >= len2) {
                    this.m_bb.get(dst, off + cursor, len2);
                    cursor += len2;
                    break;
                }
                int len3 = this.m_bb.remaining();
                this.m_bb.get(dst, off + cursor, len3);
                cursor += len3;
            }
            return cursor;
        }
    }

    class WORMOutputStream
    extends IPSOutputStream {
        private final byte[] m_buffer = new byte[16384];
        private int m_cursor = 0;
        private int m_bytesWritten = 0;
        private boolean m_open = true;
        private ByteArrayOutputStream m_hdrData = null;
        private DataOutputStream m_header = null;

        WORMOutputStream() {
        }

        @Override
        public long getAddr() {
            if (!this.m_open) {
                throw new IllegalStateException();
            }
            this.m_open = false;
            if (this.m_cursor == 0) {
                return 0L;
            }
            ByteBuffer bb = ByteBuffer.wrap(this.m_buffer, 0, this.m_cursor);
            long addr = AbstractRawStore.this.write(bb);
            this.m_bytesWritten += this.m_cursor;
            if (this.m_header == null) {
                return addr;
            }
            try {
                this.m_header.writeLong(addr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ByteBuffer hbb = ByteBuffer.wrap(this.m_hdrData.toByteArray());
            long hdrAddr = AbstractRawStore.this.write(hbb);
            IAddressManager am = AbstractRawStore.this.getAddressManager();
            return -am.toAddr(this.m_bytesWritten, am.getOffset(hdrAddr));
        }

        @Override
        public void write(int b) throws IOException {
            if (this.m_cursor == 16384) {
                ByteBuffer bb = ByteBuffer.wrap(this.m_buffer);
                long waddr = AbstractRawStore.this.write(bb);
                if (this.m_header == null) {
                    this.m_hdrData = new ByteArrayOutputStream();
                    this.m_header = new DataOutputStream(this.m_hdrData);
                }
                this.m_header.writeLong(waddr);
                this.m_cursor = 0;
                this.m_bytesWritten += 16384;
            }
            this.m_buffer[this.m_cursor++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.m_open) {
                throw new IllegalStateException("Already written");
            }
            if (this.m_cursor + len > 16384) {
                for (int i = 0; i < len; ++i) {
                    this.write(b[off + i]);
                }
            } else {
                System.arraycopy(b, off, this.m_buffer, this.m_cursor, len);
                this.m_cursor += len;
            }
        }
    }
}

