/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.quorum.AbstractQuorumClient;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumActor;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.quorum.QuorumStateChangeListener;
import java.rmi.Remote;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractQuorumMember<S extends Remote>
extends AbstractQuorumClient<S>
implements QuorumMember<S> {
    private final UUID serviceId;
    private final CopyOnWriteArraySet<QuorumStateChangeListener> listeners = new CopyOnWriteArraySet();

    protected AbstractQuorumMember(String logicalServiceId, UUID serviceId) {
        super(logicalServiceId);
        if (serviceId == null) {
            throw new IllegalArgumentException();
        }
        this.serviceId = serviceId;
    }

    @Override
    public S getLeader(long token) {
        Quorum<?, ?> q = this.getQuorum();
        q.assertQuorum(token);
        UUID leaderId = q.getLeaderId();
        if (leaderId == null) {
            q.assertQuorum(token);
            throw new AssertionError();
        }
        return this.getService(leaderId);
    }

    @Override
    public abstract S getService(UUID var1);

    @Override
    public UUID getServiceId() {
        return this.serviceId;
    }

    @Override
    public QuorumActor<S, QuorumMember<S>> getActor() {
        return this.getQuorum().getActor();
    }

    @Override
    public boolean isMember() {
        UUID[] a;
        for (UUID t : a = this.getQuorum().getMembers()) {
            if (!this.serviceId.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPipelineMember() {
        UUID[] a;
        for (UUID t : a = this.getQuorum().getPipeline()) {
            if (!this.serviceId.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJoinedMember(long token) {
        UUID[] a;
        for (UUID t : a = this.getQuorum().getJoined()) {
            if (!this.serviceId.equals(t)) continue;
            return this.getQuorum().token() == token;
        }
        return false;
    }

    @Override
    public boolean isLeader(long token) {
        if (!this.getServiceId().equals(this.getQuorum().getLeaderId())) {
            return false;
        }
        this.getQuorum().assertQuorum(token);
        return true;
    }

    @Override
    public boolean isFollower(long token) {
        UUID serviceId = this.getServiceId();
        UUID[] joined = this.getQuorum().getJoined();
        for (int i = 0; i < joined.length; ++i) {
            boolean eq = serviceId.equals(joined[i]);
            if (!eq) continue;
            if (i == 0) {
                return false;
            }
            this.getQuorum().assertQuorum(token);
            return true;
        }
        return false;
    }

    @Override
    public boolean isLastInChain(long token) {
        UUID[] pipeline;
        UUID serviceId = this.getServiceId();
        if (serviceId.equals((pipeline = this.getQuorum().getPipeline())[pipeline.length - 1])) {
            this.getQuorum().assertQuorum(token);
            return true;
        }
        return false;
    }

    @Override
    public UUID getDownstreamServiceId() {
        UUID serviceId = this.getServiceId();
        UUID[] pipeline = this.getQuorum().getPipeline();
        for (int i = 0; i < pipeline.length - 1; ++i) {
            boolean eq = serviceId.equals(pipeline[i]);
            if (!eq) continue;
            UUID nextId = pipeline[i + 1];
            return nextId;
        }
        return null;
    }

    protected void assertQuorum(long token) {
        this.getQuorum().assertQuorum(token);
    }

    @Override
    public void assertLeader(long token) {
        this.getQuorum().assertLeader(token);
    }

    protected void assertFollower(long token) {
        UUID serviceId = this.getServiceId();
        UUID[] joined = this.getQuorum().getJoined();
        for (int i = 0; i < joined.length; ++i) {
            boolean eq = serviceId.equals(joined[i]);
            if (!eq) continue;
            if (i == 0) {
                throw new QuorumException();
            }
            this.getQuorum().assertQuorum(token);
        }
        throw new QuorumException();
    }

    protected void addListener(QuorumStateChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    protected void removeListener(QuorumStateChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    @Override
    public void memberAdd() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.memberAdd();
        }
    }

    @Override
    public void memberRemove() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.memberRemove();
        }
    }

    @Override
    public void pipelineAdd() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.pipelineAdd();
        }
    }

    @Override
    public void pipelineRemove() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.pipelineRemove();
        }
    }

    @Override
    public void pipelineElectedLeader() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.pipelineElectedLeader();
        }
    }

    @Override
    public void pipelineChange(UUID oldDownStreamId, UUID newDownStreamId) {
        for (QuorumStateChangeListener l : this.listeners) {
            l.pipelineChange(oldDownStreamId, newDownStreamId);
        }
    }

    @Override
    public void pipelineUpstreamChange() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.pipelineUpstreamChange();
        }
    }

    @Override
    public void consensus(long lastCommitTime) {
        for (QuorumStateChangeListener l : this.listeners) {
            l.consensus(lastCommitTime);
        }
    }

    @Override
    public void lostConsensus() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.lostConsensus();
        }
    }

    @Override
    public void serviceJoin() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.serviceJoin();
        }
    }

    @Override
    public void serviceLeave() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.serviceLeave();
        }
    }

    @Override
    public void quorumBreak() {
        for (QuorumStateChangeListener l : this.listeners) {
            l.quorumBreak();
        }
    }

    @Override
    public void quorumMeet(long token, UUID leaderId) {
        for (QuorumStateChangeListener l : this.listeners) {
            l.quorumMeet(token, leaderId);
        }
    }
}

