/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.btree.IndexInconsistentError;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IRootBlockView;
import java.nio.ByteBuffer;

public class RootBlockCommitter
implements ICommitter {
    private final AbstractJournal journal;
    private volatile Throwable error = null;

    public RootBlockCommitter(AbstractJournal journal) {
        this.journal = journal;
    }

    @Override
    public long handleCommit(long commitTime) {
        if (this.error != null) {
            throw new IndexInconsistentError(this.error);
        }
        IRootBlockView view = this.journal.getRootBlockView();
        ByteBuffer rbv = view.asReadOnlyBuffer();
        ByteBuffer bb = ByteBuffer.allocate(rbv.capacity());
        for (int i = 0; i < rbv.capacity(); ++i) {
            bb.put(rbv.get());
        }
        bb.flip();
        return this.journal.write(bb);
    }

    @Override
    public void invalidate(Throwable t) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (this.error == null) {
            this.error = t;
        }
    }
}

