/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import org.apache.log4j.Logger;

public class CommitCounterUtility {
    private static final Logger log = Logger.getLogger(CommitCounterUtility.class);
    private static final int DIGITS_PER_DIR = 3;
    private static final int FILES_PER_DIR = 1000;
    private static final int ROOT_DIR_DEPTH = 0;
    private static final int LEAF_DIR_DEPTH = 6;
    private static final int BASENAME_DIGITS = 21;
    private static final String FORMAT_STR = "%021d";

    public static int getBasenameDigits() {
        return 21;
    }

    public static int getDigitsPerDirectory() {
        return 3;
    }

    public static int getFilesPerDirectory() {
        return 1000;
    }

    public static int getRootDirectoryDepth() {
        return 0;
    }

    public static int getLeafDirectoryDepth() {
        return 6;
    }

    public static File getCommitCounterFile(File dir, long commitCounter, String ext) {
        String basename = CommitCounterUtility.getCommitCounterStr(commitCounter);
        File t = dir;
        for (int i = 0; i < 18; i += 3) {
            t = new File(t, basename.substring(i, i + 3));
        }
        File file = new File(t, basename + ext);
        return file;
    }

    public static String getCommitCounterStr(long commitCounter) {
        StringBuilder sb = new StringBuilder(21);
        Formatter f = new Formatter(sb);
        f.format(FORMAT_STR, commitCounter);
        f.flush();
        f.close();
        String basename = sb.toString();
        return basename;
    }

    public static long parseCommitCounterFile(String name, String ext) throws NumberFormatException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (ext == null) {
            throw new IllegalArgumentException();
        }
        int len = name.length() - ext.length();
        String fileBaseName = name.substring(0, len);
        long commitCounter = Long.parseLong(fileBaseName);
        return commitCounter;
    }

    public static String getBaseName(String name, String ext) {
        String basename = name.substring(0, name.length() - ext.length());
        return basename;
    }

    public static void recursiveDelete(boolean errorIfDeleteFails, File f, FileFilter fileFilter) throws IOException {
        boolean deleted;
        if (f.isDirectory()) {
            File[] children = f.listFiles(fileFilter);
            for (int i = 0; i < children.length; ++i) {
                CommitCounterUtility.recursiveDelete(errorIfDeleteFails, children[i], fileFilter);
            }
        }
        if (!f.exists()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing: " + f));
        }
        if (!(deleted = f.delete())) {
            if (f.isDirectory() && f.list().length != 0) {
                return;
            }
            String msg = "Could not remove file: " + f;
            if (errorIfDeleteFails) {
                throw new IOException(msg);
            }
            log.warn((Object)msg);
        }
    }

    public static File findGreatestCommitCounter(File f, FileFilter fileFilter) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException();
        }
        if (fileFilter == null) {
            throw new IllegalArgumentException();
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles(fileFilter);
            Arrays.sort(files, ReverseFileComparator.INSTANCE);
            for (int i = 0; i < files.length; ++i) {
                File tmp = CommitCounterUtility.findGreatestCommitCounter(files[i], fileFilter);
                if (tmp == null) continue;
                return tmp;
            }
        } else if (fileFilter.accept(f)) {
            return f;
        }
        return null;
    }

    private static class ReverseFileComparator
    implements Comparator<File> {
        private static final Comparator<File> INSTANCE = new ReverseFileComparator();

        private ReverseFileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o2.compareTo(o1);
        }
    }
}

