/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.compression;

import com.bigdata.io.compression.GZipCompressor;
import com.bigdata.io.compression.IRecordCompressor;
import com.bigdata.io.compression.NOPRecordCompressor;
import com.bigdata.io.compression.RecordCompressor;
import java.util.concurrent.ConcurrentHashMap;

public class CompressorRegistry {
    public static final String DEFLATE_BEST_SPEED = "DBS";
    public static final String DEFLATE_BEST_COMPRESSION = "DBC";
    public static final String GZIP = "GZIP";
    public static final String NOP = "NOP";
    private static CompressorRegistry DEFAULT = new CompressorRegistry();
    private final ConcurrentHashMap<String, IRecordCompressor> compressors = new ConcurrentHashMap();

    public static CompressorRegistry getInstance() {
        return DEFAULT;
    }

    private CompressorRegistry() {
        this.add(DEFLATE_BEST_SPEED, new RecordCompressor(1));
        this.add(DEFLATE_BEST_COMPRESSION, new RecordCompressor(9));
        this.add(GZIP, new GZipCompressor());
        this.add(NOP, new NOPRecordCompressor());
    }

    public void add(String key, IRecordCompressor compressor) {
        if (this.compressors.putIfAbsent(key, compressor) != null) {
            throw new UnsupportedOperationException("Already declared: " + key);
        }
    }

    public IRecordCompressor get(String key) {
        if (key == null) {
            return null;
        }
        return this.compressors.get(key);
    }
}

