/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.IBufferAccess;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class DirectBufferPool {
    private static final Logger log = Logger.getLogger(DirectBufferPool.class);
    private final String name;
    private final BlockingQueue<ByteBuffer> pool;
    private int size = 0;
    private int acquired = 0;
    private final CAT leaked = new CAT();
    private final int poolCapacity;
    private final int bufferCapacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition bufferRelease = this.lock.newCondition();
    static final CAT totalAcquireCount = new CAT();
    static final CAT totalReleaseCount = new CAT();
    private static final boolean DEBUG;
    public static final DirectBufferPool INSTANCE;
    private static List<DirectBufferPool> pools;

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAcquiredBufferCount() {
        this.lock.lock();
        try {
            int n = this.acquired;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    protected DirectBufferPool(String name, int poolCapacity, int bufferCapacity) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (poolCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (bufferCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.poolCapacity = poolCapacity;
        this.bufferCapacity = bufferCapacity;
        this.pool = new LinkedBlockingQueue<ByteBuffer>(poolCapacity);
        pools.add(this);
    }

    public IBufferAccess acquire() throws InterruptedException {
        try {
            return this.acquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBufferAccess acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            if (this.pool.isEmpty()) {
                this.allocate(timeout, unit);
            }
            ByteBuffer buf = this.pool.take();
            ++this.acquired;
            totalAcquireCount.increment();
            buf.clear();
            if (log.isTraceEnabled()) {
                RuntimeException t = new RuntimeException("Stack trace of buffer acquisition");
                log.trace((Object)t, (Throwable)t);
            }
            BufferState bufferState = new BufferState(buf);
            return bufferState;
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void release(ByteBuffer b) throws InterruptedException {
        if (!this.release(b, Long.MAX_VALUE, TimeUnit.MILLISECONDS)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean release(ByteBuffer b, long timeout, TimeUnit units) throws InterruptedException {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (!this.pool.offer(b, timeout, units)) {
                boolean bl = false;
                return bl;
            }
            --this.acquired;
            totalReleaseCount.increment();
            this.bufferRelease.signal();
            if (log.isTraceEnabled()) {
                RuntimeException t = new RuntimeException("Stack trace of buffer release");
                log.trace((Object)t, (Throwable)t);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void allocate(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        assert (this.lock.isHeldByCurrentThread());
        if (log.isDebugEnabled()) {
            log.debug((Object)"");
        }
        if (this.size >= this.poolCapacity) {
            log.error((Object)"Pool is at capacity - waiting for a free buffer");
            this.awaitFreeBuffer(timeout, unit);
        }
        ByteBuffer b = ByteBuffer.allocateDirect(this.bufferCapacity);
        ++this.size;
        this.pool.add(b);
        return;
    }

    private void awaitFreeBuffer(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.bufferRelease.await(timeout, unit)) {
            throw new TimeoutException();
        }
        assert (!this.pool.isEmpty());
    }

    public static CounterSet getCounters() {
        CounterSet tmp = new CounterSet();
        int bufferPoolCount = 0;
        int bufferInUseCount = 0;
        int totalAcquired = 0;
        AtomicLong totalBytesUsed = new AtomicLong(0L);
        for (DirectBufferPool p : pools) {
            CounterSet c = tmp.makePath(p.getName());
            int poolSize = p.getPoolSize();
            int poolCapacity = p.getPoolCapacity();
            int bufferCapacity = p.getBufferCapacity();
            int acquired = p.getAcquiredBufferCount();
            long nleaked = p.leaked.get();
            long bytesUsed = poolSize * bufferCapacity;
            ++bufferPoolCount;
            bufferInUseCount += poolSize;
            totalAcquired += acquired;
            totalBytesUsed.addAndGet(bytesUsed);
            c.addCounter("poolCapacity", new OneShotInstrument<Integer>(poolCapacity));
            c.addCounter("bufferCapacity", new OneShotInstrument<Integer>(bufferCapacity));
            c.addCounter("acquired", new OneShotInstrument<Integer>(acquired));
            c.addCounter("leaked", new OneShotInstrument<Long>(nleaked));
            c.addCounter("poolSize", new OneShotInstrument<Integer>(poolSize));
            c.addCounter("bytesUsed", new OneShotInstrument<Long>(bytesUsed));
        }
        tmp.addCounter("totalAcquired", new OneShotInstrument<Integer>(totalAcquired));
        tmp.addCounter("bufferPoolCount", new OneShotInstrument<Integer>(bufferPoolCount));
        tmp.addCounter("bufferInUseCount", new OneShotInstrument<Integer>(bufferInUseCount));
        tmp.addCounter("totalBytesUsed", new OneShotInstrument<Long>(totalBytesUsed.get()));
        return tmp;
    }

    static {
        pools = Collections.synchronizedList(new LinkedList());
        int poolCapacity = Integer.parseInt(System.getProperty(Options.POOL_CAPACITY, "2147483647"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.POOL_CAPACITY + "=" + poolCapacity));
        }
        int bufferCapacity = Integer.parseInt(System.getProperty(Options.BUFFER_CAPACITY, "1048576"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.BUFFER_CAPACITY + "=" + bufferCapacity));
        }
        DEBUG = Boolean.valueOf(System.getProperty(Options.DEBUG, "false"));
        INSTANCE = new DirectBufferPool("default", poolCapacity, bufferCapacity);
    }

    public static interface Options {
        public static final String POOL_CAPACITY = DirectBufferPool.class.getName() + ".poolCapacity";
        public static final String DEFAULT_POOL_CAPACITY = "2147483647";
        public static final String BUFFER_CAPACITY = DirectBufferPool.class.getName() + ".bufferCapacity";
        public static final String DEFAULT_BUFFER_CAPACITY = "1048576";
        public static final String DEBUG = DirectBufferPool.class.getName() + ".debug";
        public static final String DEFAULT_DEBUG = "false";
    }

    private class BufferState
    implements IBufferAccess {
        private volatile ByteBuffer buf;
        private final Throwable allocationStack;
        private Throwable releaseStack;
        private boolean releasedByFinalizer = false;

        BufferState(ByteBuffer buf) {
            if (buf == null) {
                throw new IllegalArgumentException();
            }
            this.buf = buf;
            this.allocationStack = DEBUG ? new RuntimeException("Allocation") : null;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BufferState)) {
                return false;
            }
            if (this.buf == ((BufferState)o).buf) {
                throw new AssertionError();
            }
            return false;
        }

        public String toString() {
            ByteBuffer tmp = this.buf;
            return super.toString() + "{buf" + (tmp == null ? "N/A" : "buf.capacity=" + this.buf.capacity()) + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer buffer() {
            BufferState bufferState = this;
            synchronized (bufferState) {
                if (this.buf == null) {
                    throw new IllegalStateException();
                }
                return this.buf;
            }
        }

        @Override
        public void release() throws InterruptedException {
            this.release(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release(long timeout, TimeUnit units) throws InterruptedException {
            BufferState bufferState = this;
            synchronized (bufferState) {
                if (this.buf == null) {
                    if (this.releasedByFinalizer) {
                        return;
                    }
                    if (DEBUG) {
                        log.error((Object)"Double release: AllocationTrace", this.allocationStack);
                        if (this.releaseStack == null) {
                            log.error((Object)"Double release: FirstReleaseStack NOT available");
                        } else {
                            log.error((Object)("Double release: FirstReleaseStack: " + this.releaseStack), this.releaseStack);
                        }
                        log.error((Object)"Double release: DoubleReleaseStack", (Throwable)new RuntimeException("DoubleReleaseStack"));
                    }
                    return;
                }
                DirectBufferPool.this.release(this.buf, timeout, units);
                this.buf = null;
                if (DEBUG) {
                    this.releaseStack = new RuntimeException("ReleaseTrace");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            int nacquired;
            ByteBuffer buf;
            BufferState bufferState = this;
            synchronized (bufferState) {
                buf = this.buf;
                this.buf = null;
                nacquired = DirectBufferPool.this.acquired;
                if (buf != null) {
                    this.releasedByFinalizer = true;
                    if (this.releaseStack == null) {
                        this.releaseStack = new RuntimeException("ReleasedInFinalizer");
                    }
                }
            }
            if (buf == null) {
                return;
            }
            if (DEBUG) {
                DirectBufferPool.this.leaked.increment();
                long nleaked = DirectBufferPool.this.leaked.get();
                log.error((Object)("Buffer release on finalize (nacquired=" + nacquired + ",nleaked=" + nleaked + "): AllocationStack"), this.allocationStack);
            } else {
                DirectBufferPool.this.release(buf);
            }
        }
    }
}

