/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends FilterInputStream {
    private final InputStream in;
    private int nread = 0;

    public int getNRead() {
        return this.nread;
    }

    public ByteCountInputStream(InputStream in) {
        super(in);
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.nread;
        }
        return b;
    }

    @Override
    public int read(byte[] a) throws IOException {
        int n = this.in.read(a);
        if (n != -1) {
            this.nread += n;
        }
        return n;
    }

    @Override
    public int read(byte[] a, int off, int len) throws IOException {
        int n = this.in.read(a, off, len);
        if (n != -1) {
            this.nread += n;
        }
        return n;
    }
}

