/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.msg;

import com.bigdata.ha.msg.HAWriteMessageBase;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.compression.CompressorRegistry;
import com.bigdata.io.compression.IRecordCompressor;
import com.bigdata.journal.StoreTypeEnum;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.log4j.Logger;

public class HAWriteMessage
extends HAWriteMessageBase
implements IHAWriteMessage {
    protected static final Logger log = Logger.getLogger(HAWriteMessage.class);
    private static final long serialVersionUID = -2673171474897401979L;
    private UUID uuid;
    private long commitCounter;
    private long lastCommitTime;
    private long sequence;
    private StoreTypeEnum storeType;
    private String compressorKey;
    private long quorumToken;
    private int replicationFactor;
    private long fileExtent;
    private long firstOffset;
    private static final byte VERSION0 = 0;
    private static final byte VERSION1 = 1;
    private static final byte VERSION2 = 2;
    private static final byte VERSION3 = 3;
    private static final byte currentVersion = 3;
    private static boolean compressData = true;

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public long getCommitCounter() {
        return this.commitCounter;
    }

    @Override
    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public StoreTypeEnum getStoreType() {
        return this.storeType;
    }

    @Override
    public long getQuorumToken() {
        return this.quorumToken;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Override
    public long getFileExtent() {
        return this.fileExtent;
    }

    @Override
    public long getFirstOffset() {
        return this.firstOffset;
    }

    @Override
    public String getCompressorKey() {
        return this.compressorKey;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "{size=" + this.getSize() + ",chksum=" + this.getChk() + ",uuid=" + this.getUUID() + ",commitCounter=" + this.commitCounter + ",commitTime=" + this.lastCommitTime + ",sequence=" + this.sequence + ",storeType=" + (Object)((Object)this.getStoreType()) + ",compressorKey=" + this.getCompressorKey() + ",quorumToken=" + this.getQuorumToken() + ",replicationFactor=" + this.getReplicationFactor() + ",fileExtent=" + this.getFileExtent() + ",firstOffset=" + this.getFirstOffset() + "}";
    }

    public HAWriteMessage() {
    }

    public HAWriteMessage(UUID uuid, long commitCounter, long commitTime, long sequence, int sze, int chk, StoreTypeEnum storeType, long quorumToken, long fileExtent, long firstOffset) {
        this(uuid, commitCounter, commitTime, sequence, sze, chk, storeType, quorumToken, 0, fileExtent, firstOffset, null);
    }

    public HAWriteMessage(UUID uuid, long commitCounter, long commitTime, long sequence, int sze, int chk, StoreTypeEnum storeType, long quorumToken, int replicationFactor, long fileExtent, long firstOffset, String compressorKey) {
        super(sze, chk);
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        if (storeType == null) {
            throw new IllegalArgumentException();
        }
        this.uuid = uuid;
        this.commitCounter = commitCounter;
        this.lastCommitTime = commitTime;
        this.sequence = sequence;
        this.storeType = storeType;
        this.quorumToken = quorumToken;
        this.fileExtent = fileExtent;
        this.firstOffset = firstOffset;
        this.replicationFactor = replicationFactor;
        this.compressorKey = compressorKey;
    }

    public static boolean isDataCompressed() {
        return compressData;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IHAWriteMessage)) {
            return false;
        }
        IHAWriteMessage other = (IHAWriteMessage)obj;
        return (this.uuid == null && other.getUUID() == null || this.uuid.equals(other.getUUID())) && this.commitCounter == other.getCommitCounter() && this.lastCommitTime == other.getLastCommitTime() && this.sequence == other.getSequence() && this.storeType == other.getStoreType() && this.quorumToken == other.getQuorumToken() && this.fileExtent == other.getFileExtent() && this.firstOffset == other.getFirstOffset();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                this.uuid = null;
                break;
            }
            case 2: 
            case 3: {
                boolean isNull = in.readBoolean();
                this.compressorKey = isNull ? null : in.readUTF();
            }
            case 1: {
                this.uuid = new UUID(in.readLong(), in.readLong());
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
        this.storeType = StoreTypeEnum.valueOf(in.readByte());
        this.commitCounter = in.readLong();
        this.lastCommitTime = in.readLong();
        this.sequence = in.readLong();
        this.quorumToken = in.readLong();
        this.replicationFactor = version >= 3 ? in.readInt() : 0;
        this.fileExtent = in.readLong();
        this.firstOffset = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.uuid != null) {
            out.write(3);
            out.writeBoolean(this.compressorKey == null);
            if (this.compressorKey != null) {
                out.writeUTF(this.compressorKey);
            }
            out.writeLong(this.uuid.getMostSignificantBits());
            out.writeLong(this.uuid.getLeastSignificantBits());
        } else {
            out.write(0);
        }
        out.writeByte(this.storeType.getType());
        out.writeLong(this.commitCounter);
        out.writeLong(this.lastCommitTime);
        out.writeLong(this.sequence);
        out.writeLong(this.quorumToken);
        out.writeInt(this.replicationFactor);
        out.writeLong(this.fileExtent);
        out.writeLong(this.firstOffset);
    }

    @Override
    public ByteBuffer expand(ByteBuffer buffer) {
        String compressorKey = this.getCompressorKey();
        if (compressorKey == null) {
            return buffer;
        }
        IRecordCompressor compressor = CompressorRegistry.getInstance().get(compressorKey);
        if (compressor == null) {
            throw new UnsupportedOperationException("Unknown compressor: " + compressorKey);
        }
        return compressor.decompress(buffer);
    }
}

