/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.HistoryInstrument;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.ICounterNode;
import com.bigdata.counters.ICounterSet;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.query.CSet;
import com.bigdata.counters.query.CounterSetSelector;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.ICounterSelector;
import com.bigdata.counters.query.PivotTable;
import com.bigdata.counters.query.TimestampFormatEnum;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.query.URLQueryParam;
import com.bigdata.counters.render.DoctypeEnum;
import com.bigdata.counters.render.HTMLHistoryTableRenderer;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.PivotTableRenderer;
import com.bigdata.counters.render.ValueFormatter;
import com.bigdata.service.Event;
import com.bigdata.service.IEventReportingService;
import com.bigdata.util.HTMLUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class XHTMLRenderer
implements IRenderer {
    private static final Logger log = Logger.getLogger(XHTMLRenderer.class);
    public static final String ps = "/";
    private static final String encoding = "UTF-8";
    private static final DoctypeEnum doctype = DoctypeEnum.xhtml_1_0_strict;
    private final URLQueryModel model;
    private final ICounterSelector counterSelector;
    private static final Pattern percent_pattern = Pattern.compile(".*percent.*", 2);

    public XHTMLRenderer(URLQueryModel model, ICounterSelector counterSelector) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        if (counterSelector == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.counterSelector = counterSelector;
    }

    @Override
    public void render(Writer w) throws IOException {
        this.writeXmlDecl(w);
        this.writeDocType(w);
        this.writeHtml(w);
        this.writeHead(w);
        this.writeBody(w);
        w.write("</html\n>");
    }

    protected void writeXmlDecl(Writer w) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    protected void writeDocType(Writer w) throws IOException {
        w.write("<!DOCTYPE html PUBLIC");
        w.write(" \"" + doctype.publicId() + "\"");
        w.write(" \"" + doctype.systemId() + "\"");
        w.write(">\n");
    }

    protected void writeHtml(Writer w) throws IOException {
        w.write("<html ");
        if (doctype.isXML()) {
            w.write(" xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\"");
        }
        w.write(" lang=\"en\"");
        w.write("\n>");
    }

    protected void writeHead(Writer w) throws IOException {
        w.write("<head\n>");
        this.writeTitle(w);
        this.writeScripts(w);
        w.write("</head\n>");
    }

    protected void writeTitle(Writer w) throws IOException {
        w.write("<title>bigdata(tm) telemetry : " + XHTMLRenderer.cdata(this.model.path) + "</title\n>");
    }

    protected void writeScripts(Writer w) throws IOException {
        if (this.model.flot) {
            String s = this.model.getRequestURL().toString();
            w.write("<script\n type=\"text/javascript\" src=\"" + s + "jquery.js\"></script\n>");
            w.write("<script\n type=\"text/javascript\" src=\"" + s + "jquery.flot.js\"></script\n>");
            w.write("<!--[if IE]><script type=\"text/javascript\" src=\"" + s + "excanvas.pack.js\"></script><![endif]-->");
        }
    }

    protected void writeBody(Writer w) throws IOException {
        w.write("<body\n>");
        ICounterNode node = ((CounterSetSelector)this.counterSelector).getRoot().getPath(this.model.path);
        if (node == null) {
            w.write("<p>");
            w.write("No such counter or counter set: ");
            this.writeFullPath(w, this.model.path);
            w.write("</p>");
            return;
        }
        if (node instanceof ICounter) {
            this.writeCounter(w, (ICounter)node);
        } else {
            switch (this.model.reportType) {
                case hierarchy: {
                    this.writeCounterSet(w, (CounterSet)node, this.model.depth);
                    break;
                }
                case correlated: {
                    this.writeHistoryTable(w, this.counterSelector.selectCounters(this.model.depth, this.model.pattern, this.model.fromTime, this.model.toTime, this.model.period, true), this.model.period, this.model.timestampFormat);
                    break;
                }
                case pivot: {
                    this.writePivotTable(w, this.counterSelector.selectCounters(this.model.depth, this.model.pattern, this.model.fromTime, this.model.toTime, this.model.period, true));
                    break;
                }
                case events: {
                    this.writeFlot(w, this.model.eventReportingService);
                }
            }
        }
        w.write("</body\n>");
    }

    protected void writeFullPath(Writer w, String path) throws IOException {
        this.writePath(w, path, 0);
    }

    protected void writePath(Writer w, String path, int rootDepth) throws IOException {
        String[] a = path.split(ps);
        if (rootDepth == 0) {
            w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", ps)}) + "\">");
            w.write(ps);
            w.write("</a>");
        }
        StringBuilder sb = new StringBuilder(ps);
        for (int n = 1; n < a.length; ++n) {
            String name = a[n];
            if (n > 1) {
                if (n + 1 > rootDepth) {
                    w.write("&nbsp;");
                    w.write(ps);
                }
                sb.append(ps);
            }
            String prefix = sb.toString();
            sb.append(name);
            if (n + 1 <= rootDepth) continue;
            if (rootDepth != 0 && n == rootDepth) {
                w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", prefix)}) + "\">");
                w.write("...");
                w.write("</a>");
                w.write("&nbsp;/");
            }
            w.write("&nbsp;");
            w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", sb.toString())}) + "\">");
            w.write(XHTMLRenderer.cdata(name));
            w.write("</a>");
        }
    }

    protected void writeCounterSet(Writer w, CounterSet counterSet, int depth) throws IOException {
        int ourDepth = counterSet.getDepth();
        if (log.isInfoEnabled()) {
            log.info((Object)("path=" + counterSet.getPath() + ", depth=" + depth + ", ourDepth=" + ourDepth));
        }
        String summary = "Showing counters for path=" + counterSet.getPath();
        w.write("<table border=\"1\" summary=\"" + XHTMLRenderer.attrib(summary) + "\"\n>");
        w.write(" <caption>");
        this.writeFullPath(w, counterSet.getPath());
        w.write("</caption\n>");
        w.write(" <tr\n>");
        w.write("  <th rowspan=\"2\" >Name</th\n>");
        w.write("  <th colspan=\"3\">Averages</th\n>");
        w.write("  <th rowspan=\"2\">Current</th\n>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th>Minutes</th\n>");
        w.write("  <th>Hours</th\n>");
        w.write("  <th>Days</th\n>");
        w.write(" </tr\n>");
        Iterator<ICounterNode> itr = counterSet.getNodes(this.model.pattern);
        while (itr.hasNext()) {
            int counterDepth;
            ICounterNode node = itr.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("considering: " + node.getPath()));
            }
            if (depth != 0 && (counterDepth = node.getDepth()) - ourDepth > depth) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("skipping: " + node.getPath()));
                continue;
            }
            String path = node.getPath();
            w.write(" <tr\n>");
            if (node instanceof ICounterSet) {
                w.write("  <th align=\"left\">");
                this.writePath(w, path, ourDepth);
                w.write("  </th\n>");
                w.write("  <td colspan=\"4\">&nbsp;...</td>");
            } else {
                ICounter counter = (ICounter)node;
                w.write("  <th align=\"left\">");
                this.writePath(w, path, ourDepth);
                w.write("  </th\n>");
                if (counter.getInstrument() instanceof HistoryInstrument) {
                    HistoryInstrument inst = (HistoryInstrument)counter.getInstrument();
                    w.write("  <td>" + this.value(counter, inst.minutes.getAverage()) + " (" + this.value(counter, inst.minutes.size()) + ")" + "</td\n>");
                    w.write("  <td>" + (inst.hours == null ? "N/A" : this.value(counter, inst.hours.getAverage()) + " (" + this.value(counter, inst.hours.size()) + ")") + "</td\n>");
                    w.write("  <td>" + (inst.days == null ? "N/A" : this.value(counter, inst.days.getAverage()) + " (" + this.value(counter, inst.days.size()) + ")") + "</td\n>");
                    w.write("  <td>" + this.value(counter, counter.getValue()) + "</td\n>");
                } else {
                    w.write("  <td colspan=\"4\">" + this.value(counter, counter.getValue()) + "</td\n>");
                }
            }
            w.write(" </tr\n>");
        }
        w.write("</table\n>");
    }

    protected void writeCounter(Writer w, ICounter counter) throws IOException {
        if (counter.getInstrument() instanceof HistoryInstrument) {
            this.writeHistoryTable(w, new ICounter[]{counter}, this.model.period, this.model.timestampFormat);
        }
    }

    protected void writeHistoryTable(Writer w, ICounter[] a, PeriodEnum basePeriod, TimestampFormatEnum timestampFormat) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0) {
            return;
        }
        if (basePeriod == null) {
            throw new IllegalArgumentException();
        }
        if (timestampFormat == null) {
            throw new IllegalArgumentException();
        }
        HistoryTable t = new HistoryTable(a, basePeriod);
        block0 : switch (timestampFormat) {
            case dateTime: {
                switch (basePeriod) {
                    case Minutes: {
                        DateFormat dateFormat = DateFormat.getTimeInstance(3);
                        break block0;
                    }
                    case Hours: {
                        DateFormat dateFormat = DateFormat.getTimeInstance(2);
                        break block0;
                    }
                    case Days: {
                        DateFormat dateFormat = DateFormat.getDateInstance(2);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case epoch: {
                Object dateFormat = null;
                break;
            }
            default: {
                throw new AssertionError((Object)timestampFormat.toString());
            }
        }
        new HTMLHistoryTableRenderer(t, this.model.pattern, new HTMLValueFormatter(this.model)).render(w);
    }

    protected void writePivotTable(Writer w, ICounter[] a, PeriodEnum basePeriod, TimestampFormatEnum timestampFormat) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0) {
            return;
        }
        if (basePeriod == null) {
            throw new IllegalArgumentException();
        }
        if (timestampFormat == null) {
            throw new IllegalArgumentException();
        }
        HistoryTable t = new HistoryTable(a, basePeriod);
        PivotTable pt = new PivotTable(this.model.pattern, this.model.category, t);
        block0 : switch (timestampFormat) {
            case dateTime: {
                switch (basePeriod) {
                    case Minutes: {
                        DateFormat dateFormat = DateFormat.getTimeInstance(3);
                        break block0;
                    }
                    case Hours: {
                        DateFormat dateFormat = DateFormat.getTimeInstance(2);
                        break block0;
                    }
                    case Days: {
                        DateFormat dateFormat = DateFormat.getDateInstance(2);
                        break block0;
                    }
                }
                throw new AssertionError();
            }
            case epoch: {
                Object dateFormat = null;
                break;
            }
            default: {
                throw new AssertionError((Object)timestampFormat.toString());
            }
        }
        new HTMLPivotTableRenderer(pt, new HTMLValueFormatter(this.model)).render(w);
    }

    protected void writePivotTable(Writer w, ICounter[] a) throws IOException {
        if (this.model.period == null) {
            this.writePivotTable(w, a, PeriodEnum.Minutes, this.model.timestampFormat);
            this.writePivotTable(w, a, PeriodEnum.Hours, this.model.timestampFormat);
            this.writePivotTable(w, a, PeriodEnum.Days, this.model.timestampFormat);
        } else {
            switch (this.model.period) {
                case Minutes: {
                    this.writePivotTable(w, a, PeriodEnum.Minutes, this.model.timestampFormat);
                    break;
                }
                case Hours: {
                    this.writePivotTable(w, a, PeriodEnum.Hours, this.model.timestampFormat);
                    break;
                }
                case Days: {
                    this.writePivotTable(w, a, PeriodEnum.Days, this.model.timestampFormat);
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.model.period.toString());
                }
            }
        }
    }

    protected void writeFlot(Writer w, IEventReportingService eventReportingService) throws IOException {
        this.writeResource(w, "flot-start.txt");
        this.writeEvents(w, eventReportingService);
        this.writeResource(w, "flot-end.txt");
    }

    protected boolean acceptEvent(Event e) {
        for (Map.Entry<Field, Pattern> filterEntry : this.model.eventFilters.entrySet()) {
            String val;
            Field fld = filterEntry.getKey();
            Pattern pattern = filterEntry.getValue();
            try {
                val = "" + fld.get(e);
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not access field: " + fld);
            }
            if (pattern.matcher(val).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rejected event: fld=" + fld.getName() + " : val=" + val));
            }
            return false;
        }
        return true;
    }

    protected String getEventKey(Event e) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        for (Field f : this.model.eventOrderBy) {
            if (n > 0) {
                sb.append(":");
            }
            try {
                sb.append("" + f.get(e));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++n;
        }
        return sb.toString();
    }

    protected String getEventTable(Event e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.toString());
        return sb.toString();
    }

    protected void writeEvents(Writer w, IEventReportingService eventReportingService) throws IOException {
        String series;
        Object key;
        int i;
        String hostyvar;
        HashMap<String, String> seriesByGroup = new HashMap<String, String>();
        HashMap<String, StringBuilder> eventsByHost = new HashMap<String, StringBuilder>();
        HashMap<String, StringBuilder> tooltipsByHost = new HashMap<String, StringBuilder>();
        int naccepted = 0;
        int nvisited = 0;
        Iterator<Event> itr = eventReportingService.rangeIterator(this.model.fromTime, this.model.toTime);
        while (itr.hasNext()) {
            String series2;
            Event e = itr.next();
            ++nvisited;
            if (!e.isComplete() || !this.acceptEvent(e)) continue;
            ++naccepted;
            String key2 = this.getEventKey(e);
            StringBuilder eventsSB = (StringBuilder)eventsByHost.get(key2);
            if (eventsSB == null) {
                eventsSB = new StringBuilder();
                series2 = "series_" + seriesByGroup.size();
                seriesByGroup.put(key2, series2);
                eventsByHost.put(key2, eventsSB);
                eventsSB.append("var ");
                eventsSB.append(series2);
                eventsSB.append(" = [\n");
                StringBuilder tooltipsSB = new StringBuilder();
                String tooltipvar = series2 + "tooltips";
                tooltipsByHost.put(key2, tooltipsSB);
                tooltipsSB.append("var ");
                tooltipsSB.append(tooltipvar);
                tooltipsSB.append(" = [\n");
            } else {
                series2 = (String)seriesByGroup.get(key2);
            }
            eventsSB.append("[ ");
            eventsSB.append(e.getStartTime());
            eventsSB.append(", ");
            double offset = Math.random() * 0.85 + 0.05;
            hostyvar = series2 + "y";
            eventsSB.append(hostyvar);
            eventsSB.append((offset < 0.0 ? "" : "+") + offset + " ], [ ");
            eventsSB.append(e.getEndTime());
            eventsSB.append(", ");
            eventsSB.append(hostyvar);
            eventsSB.append((offset < 0.0 ? "" : "+") + offset + " ], null,\n");
            StringBuilder tooltipsSB = (StringBuilder)tooltipsByHost.get(key2);
            String tooltip = e.toString().replace("\n", "");
            if (tooltip != null && !tooltip.startsWith("\"")) {
                tooltipsSB.append("\"");
            }
            tooltipsSB.append(tooltip);
            if (tooltip != null && !tooltip.endsWith("\"")) {
                tooltipsSB.append("\"");
            }
            tooltipsSB.append(", null, null,\n");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("accepted: " + naccepted + " out of " + nvisited + " events"));
        }
        Object[] keys = eventsByHost.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (i = 0; i < keys.length; ++i) {
            int hosty = i;
            key = keys[i];
            StringBuilder eventsSB = new StringBuilder();
            series = (String)seriesByGroup.get(key);
            hostyvar = series + "y";
            eventsSB.append("var ");
            eventsSB.append(hostyvar);
            eventsSB.append(" = ");
            eventsSB.append(hosty);
            eventsSB.append(";\n");
            StringBuilder sb = eventsSB.append((CharSequence)eventsByHost.get(key));
            sb.setLength(sb.length() - ", null,\n".length());
            sb.append("\n];");
            w.write(sb.toString());
            w.write("\n");
        }
        for (i = 0; i < keys.length; ++i) {
            StringBuilder sb = (StringBuilder)tooltipsByHost.get(keys[i]);
            sb.setLength(sb.length() - 2);
            sb.append("\n];");
            w.write(sb.toString());
            w.write("\n");
        }
        StringBuilder data = new StringBuilder();
        data.append("var data = [\n");
        for (int i2 = keys.length - 1; i2 >= 0; --i2) {
            key = keys[i2];
            String series3 = (String)seriesByGroup.get(key);
            data.append("{ label: \"");
            data.append((String)key);
            data.append("\", data: ");
            data.append(series3);
            data.append(" },\n");
        }
        if (data.charAt(data.length() - 2) == ',') {
            data.setLength(data.length() - 2);
        }
        data.append("\n];\n");
        w.write(data.toString());
        StringBuilder tooltips = new StringBuilder();
        tooltips.append("var tooltips = [\n");
        for (int i3 = keys.length - 1; i3 >= 0; --i3) {
            Object key3 = keys[i3];
            series = (String)seriesByGroup.get(key3);
            String tooltipvar = series + "tooltips";
            tooltips.append(tooltipvar);
            tooltips.append(",\n");
        }
        if (tooltips.charAt(tooltips.length() - 2) == ',') {
            tooltips.setLength(tooltips.length() - 2);
        }
        tooltips.append("\n];\n");
        w.write(tooltips.toString());
    }

    protected void writeEventFlyover(Writer w, Event e) throws IOException {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        String summary = e.majorEventType + " from " + dateFormat.format(new Date(e.getStartTime())) + " to " + dateFormat.format(new Date(e.getEndTime())) + ", uuid=" + e.eventUUID.toString();
        w.write("<table border=\"1\" summary=\"" + XHTMLRenderer.attrib(summary) + "\"\n>");
        w.write(" <caption>");
        w.write(XHTMLRenderer.cdata(e.majorEventType + " from " + XHTMLRenderer.cdata(dateFormat.format(new Date(e.getStartTime()))) + " to " + e.getEndTime()));
        w.write("</caption\n>");
        w.write(" <tr\n>");
        w.write("  <th>From: " + XHTMLRenderer.cdata(dateFormat.format(new Date(e.getStartTime()))) + "</th\n>");
        w.write("  <th>To: " + XHTMLRenderer.cdata(dateFormat.format(new Date(e.getEndTime()))) + "</th\n>");
        w.write("  <th>Duration: " + (e.getEndTime() - e.getStartTime()) + "s</th\n>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">hostname</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.hostname.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">serviceIface</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.serviceIface.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">serviceName</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.serviceName.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">serviceUUID</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.serviceUUID.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">resource</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.resource.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">minorEventType</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.minorEventType.toString()) + "</td>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th align=\"left\">majorEventType</th>");
        w.write("  <td colspan=\"2\">" + XHTMLRenderer.cdata(e.majorEventType.toString()) + "</td>");
        w.write(" </tr\n>");
        if (e.getDetails() != null && e.getDetails().size() > 0) {
            for (Map.Entry<String, Object> entry : e.getDetails().entrySet()) {
                w.write(" <tr\n>");
                w.write("  <th align=\"left\">" + XHTMLRenderer.cdata(entry.getKey()) + "</th>");
                w.write("  <td colspan=\"4\">" + XHTMLRenderer.cdata("" + entry.getValue()) + "</td>");
                w.write(" </tr\n>");
            }
        }
        w.write("</table\n>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResource(Writer w, String resource) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("Resource not on classpath: " + resource);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String s = null;
            boolean first = true;
            while ((s = reader.readLine()) != null) {
                if (!first) {
                    w.write("\n");
                }
                w.write(s);
                first = false;
            }
        }
        finally {
            is.close();
        }
    }

    public static String cdata(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return HTMLUtility.escapeForXHTML((String)s);
    }

    public static String attrib(String s) {
        return HTMLUtility.escapeForXHTML((String)s);
    }

    protected String value(ICounter<?> counter, Object val) {
        if (counter == null) {
            throw new IllegalArgumentException();
        }
        if (val == null) {
            return XHTMLRenderer.cdata("N/A");
        }
        if (val instanceof Double || val instanceof Float) {
            NumberFormat fmt = this.model.decimalFormat;
            if (counter.getName().contains("%") || percent_pattern.matcher(counter.getName()).matches()) {
                fmt = this.model.percentFormat;
            }
            return XHTMLRenderer.cdata(fmt.format((Object)((Number)val).doubleValue()));
        }
        if (val instanceof Long || val instanceof Integer) {
            NumberFormat fmt = this.model.integerFormat;
            return XHTMLRenderer.cdata(fmt.format((Object)((Number)val).longValue()));
        }
        if (counter.getName().equals("Local httpd")) {
            return "<a href=" + val + ">" + XHTMLRenderer.cdata(val.toString()) + "</a>";
        }
        return XHTMLRenderer.cdata(val.toString());
    }

    public static class HTMLPivotTableRenderer
    extends PivotTableRenderer {
        public HTMLPivotTableRenderer(PivotTable pt, ValueFormatter formatter) {
            super(pt, formatter);
        }

        @Override
        public void render(Writer w) throws IOException {
            HistoryTable t = this.pt.src;
            String summary = "Showing samples: period=" + t.units;
            w.write("<table border=\"1\" summary=\"" + XHTMLRenderer.attrib(summary) + "\"\n>");
            w.write(" <tr\n>");
            w.write("  <th>" + XHTMLRenderer.cdata(t.units) + "</th\n>");
            w.write("  <th>" + XHTMLRenderer.cdata("timestamp") + "</th\n>");
            for (String s : this.pt.cnames) {
                w.write("  <th>" + XHTMLRenderer.cdata(s) + "</th\n>");
            }
            for (String s : this.pt.vcols) {
                w.write("  <th>" + XHTMLRenderer.cdata(s) + "</th\n>");
            }
            w.write(" </tr\n>");
            for (int row = 0; row < t.nrows; ++row) {
                long timestamp = t.getTimestamp(row);
                String unitStr = XHTMLRenderer.cdata(this.formatter.unitsFormat.format(((double)timestamp - (double)t.getTimestamp(0)) / (double)t.period));
                String timeStr = XHTMLRenderer.cdata(this.formatter.date(timestamp));
                for (CSet cset : this.pt.csets) {
                    int j;
                    assert (cset.cats.length == this.pt.cnames.length) : "cset categories=" + Arrays.toString(cset.cats) + " vs " + "category names: " + Arrays.toString(this.pt.cnames);
                    Double[] vals = new Double[this.pt.vcols.size()];
                    int ndefined = 0;
                    int valueColumnIndex = 0;
                    for (String vcol : this.pt.vcols) {
                        int valueCountForColumn = 0;
                        double val = 0.0;
                        block5: for (ICounter c : cset.counters) {
                            if (!c.getName().equals(vcol)) continue;
                            for (int col = 0; col < t.a.length; ++col) {
                                IHistoryEntry e;
                                if (c != t.a[col] || (e = t.data[row][col]) == null) continue;
                                val += ((Number)e.getValue()).doubleValue();
                                ++valueCountForColumn;
                                continue block5;
                            }
                        }
                        if (valueCountForColumn > 0) {
                            vals[valueColumnIndex] = val;
                            ++ndefined;
                        }
                        if (log.isDebugEnabled() && valueCountForColumn > 0) {
                            log.debug((Object)("vcol=" + vcol + ", vcol#=" + valueColumnIndex + ", #values=" + valueCountForColumn + ", val=" + val));
                        }
                        ++valueColumnIndex;
                    }
                    if (ndefined == 0) continue;
                    w.write(" <tr\n>");
                    w.write("  <td>" + unitStr + "</td\n>");
                    w.write("  <td>" + timeStr + "</td\n>");
                    for (j = 0; j < this.pt.cnames.length; ++j) {
                        w.write("  <td>" + cset.cats[j] + "</td\n>");
                    }
                    for (j = 0; j < vals.length; ++j) {
                        String s = vals[j] == null ? "" : Double.toString(vals[j]);
                        w.write("  <td>" + s + "</td\n>");
                    }
                    w.write(" </tr\n>");
                }
            }
            w.write("</table\n>");
        }
    }

    public class HTMLValueFormatter
    extends ValueFormatter {
        private final URLQueryModel model;

        public HTMLValueFormatter(URLQueryModel model) {
            super(model);
            this.model = model;
        }

        @Override
        public String value(ICounter counter, Object val) {
            return XHTMLRenderer.this.value(counter, val);
        }

        @Override
        public void writeFullPath(Writer w, String path) throws IOException {
            this.writePath(w, path, 0);
        }

        @Override
        public void writePath(Writer w, String path, int rootDepth) throws IOException {
            String[] a = path.split(XHTMLRenderer.ps);
            if (rootDepth == 0) {
                w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", XHTMLRenderer.ps)}) + "\">");
                w.write(XHTMLRenderer.ps);
                w.write("</a>");
            }
            StringBuilder sb = new StringBuilder(XHTMLRenderer.ps);
            for (int n = 1; n < a.length; ++n) {
                String name = a[n];
                if (n > 1) {
                    if (n + 1 > rootDepth) {
                        w.write("&nbsp;");
                        w.write(XHTMLRenderer.ps);
                    }
                    sb.append(XHTMLRenderer.ps);
                }
                String prefix = sb.toString();
                sb.append(name);
                if (n + 1 <= rootDepth) continue;
                if (rootDepth != 0 && n == rootDepth) {
                    w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", prefix)}) + "\">");
                    w.write("...");
                    w.write("</a>");
                    w.write("&nbsp;/");
                }
                w.write("&nbsp;");
                w.write("<a href=\"" + this.model.getRequestURL(new URLQueryParam[]{new URLQueryParam("path", sb.toString())}) + "\">");
                w.write(XHTMLRenderer.cdata(name));
                w.write("</a>");
            }
        }
    }
}

