/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.Banner;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.httpd.DummyEventReportingService;
import com.bigdata.counters.query.CounterSetSelector;
import com.bigdata.counters.query.QueryUtil;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.RendererFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class CounterSetQuery {
    private static final Logger log = Logger.getLogger(CounterSetQuery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<URL> readURLsFromFile(File file) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading queries: " + file));
        }
        LinkedList<URL> tmp = new LinkedList<URL>();
        try (BufferedReader r = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = r.readLine()) != null) {
                if ((s = s.trim()).isEmpty() || s.startsWith("#")) continue;
                tmp.add(new URL(s));
            }
        }
        return tmp;
    }

    private static Collection<URL> readURLs(File file) throws IOException {
        LinkedList<URL> urls = new LinkedList<URL>();
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isHidden()) continue;
                urls.addAll(CounterSetQuery.readURLsFromFile(f));
            }
        } else {
            urls.addAll(CounterSetQuery.readURLsFromFile(file));
        }
        return urls;
    }

    private static void readFiles(Collection<File> counterSetFiles, CounterSet counterSet, int nsamples, PeriodEnum period, Pattern regex) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        Collection<File> flatFileList = QueryUtil.collectFiles(counterSetFiles, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isHidden() && pathname.getName().endsWith(".xml");
            }
        });
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading performance counters from " + flatFileList.size() + " sources."));
        }
        CounterSetQuery.readFilesParallel(flatFileList, counterSet, nsamples, period, regex);
    }

    private static void readFilesSequential(Collection<File> counterSetFiles, CounterSet counterSet, int nsamples, PeriodEnum period, Pattern regex) throws IOException, SAXException, ParserConfigurationException {
        for (File file : counterSetFiles) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading file: " + file));
            }
            QueryUtil.readCountersFromFile(file, counterSet, regex, nsamples, period);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFilesParallel(Collection<File> counterSetFiles, CounterSet counterSet, int nsamples, PeriodEnum period, Pattern regex) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        List futures;
        int nfiles = counterSetFiles.size();
        ArrayList<QueryUtil.ReadCounterSetXMLFileTask> tasks = new ArrayList<QueryUtil.ReadCounterSetXMLFileTask>(nfiles);
        for (File file : counterSetFiles) {
            tasks.add(new QueryUtil.ReadCounterSetXMLFileTask(file, counterSet, nsamples, period, regex));
        }
        ExecutorService service = Executors.newFixedThreadPool(nfiles);
        try {
            futures = service.invokeAll(tasks);
        }
        finally {
            service.shutdownNow();
        }
        int i = 0;
        int nerrors = 0;
        for (Future future : futures) {
            block9: {
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    if (!(ex.getCause() instanceof SAXException)) break block9;
                    log.warn((Object)("Could not parse file (ignored): " + tasks.get(i)), (Throwable)ex);
                    ++nerrors;
                    continue;
                }
            }
            ++i;
        }
        if (nerrors != 0) {
            log.error((Object)("There were " + nerrors + " errors."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        Banner.banner();
        if (args.length == 0) {
            System.err.println("See javadoc for usage.");
            System.exit(1);
        }
        DummyEventReportingService service = new DummyEventReportingService();
        String defaultMimeType = "text/plain";
        int nsamples = 10080;
        File outputDir = new File(".");
        LinkedList<URLQueryModel> queries = new LinkedList<URLQueryModel>();
        LinkedList<File> counterSetFiles = new LinkedList<File>();
        for (int i = 0; i < args.length; ++i) {
            File file;
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-outputDir")) {
                    outputDir = new File(args[++i]);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("outputDir: " + outputDir));
                    }
                    if (outputDir.exists()) continue;
                    outputDir.mkdirs();
                    continue;
                }
                if (arg.equals("-mimeType")) {
                    defaultMimeType = args[++i];
                    continue;
                }
                if (arg.equals("-nsamples")) {
                    if ((nsamples = Integer.valueOf(args[++i]).intValue()) > 0) continue;
                    throw new IllegalArgumentException("nslots must be positive.");
                }
                if (arg.equals("-events")) {
                    QueryUtil.readEvents(service, new File(args[++i]));
                    continue;
                }
                if (arg.equals("-queries")) {
                    file = new File(args[++i]);
                    Collection<URL> urls = CounterSetQuery.readURLs(file);
                    for (URL url : urls) {
                        queries.add(URLQueryModel.getInstance(url));
                    }
                    continue;
                }
                System.err.println("Unknown option: " + arg);
                System.exit(1);
                continue;
            }
            file = new File(arg);
            if (!file.exists()) {
                throw new FileNotFoundException(file.toString());
            }
            counterSetFiles.add(file);
        }
        if (queries.isEmpty()) {
            throw new RuntimeException("No queries were specified.");
        }
        if (counterSetFiles.isEmpty()) {
            throw new RuntimeException("No counter set files were specified.");
        }
        LinkedList<Pattern> tmp = new LinkedList<Pattern>();
        for (URLQueryModel model : queries) {
            if (model.pattern == null) continue;
            tmp.add(model.pattern);
        }
        Pattern regex = QueryUtil.getPattern(tmp);
        CounterSet counterSet = new CounterSet();
        CounterSetQuery.readFiles(counterSetFiles, counterSet, nsamples, PeriodEnum.Minutes, regex);
        if (log.isInfoEnabled()) {
            log.info((Object)("Evaluating " + queries.size() + " queries."));
        }
        for (URLQueryModel model : queries) {
            try {
                IRenderer renderer = RendererFactory.get(model, new CounterSetSelector(counterSet), defaultMimeType);
                File file = model.file == null ? File.createTempFile("query", ".out", outputDir) : (!model.file.isAbsolute() ? new File(outputDir, model.file.toString()) : model.file);
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Creating directory: " + file.getParentFile()));
                    }
                    file.getParentFile().mkdirs();
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Writing file: " + file + " for query: " + model.uri));
                }
                try (BufferedWriter w = new BufferedWriter(new FileWriter(file, false));){
                    renderer.render(w);
                    ((Writer)w).flush();
                }
            }
            catch (Throwable t) {
                log.error((Object)("Could not run query: " + model.uri), t);
            }
        }
    }
}

