/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba.codec;

import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.AbstractCodedRaba;
import com.bigdata.btree.raba.codec.ICodedRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.AbstractFixedByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import it.unimi.dsi.fastutil.bytes.custom.CustomByteArrayFrontCodedList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FrontCodedRabaCoder
implements IRabaCoder,
Externalizable {
    private static final long serialVersionUID = 4943035649252818747L;
    protected static final Logger log = Logger.getLogger(FrontCodedRabaCoder.class);
    private int ratio;
    private static final byte VERSION0 = 0;
    private static final int SIZEOF_VERSION = 1;
    private static final int SIZEOF_SIZE = 4;
    private static final int SIZEOF_RATIO = 4;
    private static final int O_VERSION = 0;
    private static final int O_SIZE = 1;
    private static final int O_RATIO = 5;
    private static final int O_DATA = 9;

    public String toString() {
        return super.toString() + "{ratio=" + this.ratio + "}";
    }

    public FrontCodedRabaCoder() {
    }

    public FrontCodedRabaCoder(int ratio) {
        this.ratio = ratio;
    }

    @Override
    public final boolean isKeyCoder() {
        return true;
    }

    @Override
    public final boolean isValueCoder() {
        return false;
    }

    @Override
    public boolean isDuplicateKeys() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ratio = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.ratio);
    }

    @Override
    public ICodedRaba encodeLive(IRaba raba, DataOutputBuffer buf) {
        if (raba == null) {
            throw new IllegalArgumentException();
        }
        if (!raba.isKeys()) {
            throw new UnsupportedOperationException("Must be keys.");
        }
        if (buf == null) {
            throw new IllegalArgumentException();
        }
        int size = raba.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("n=" + raba.size() + ", capacity=" + raba.capacity() + ", ratio=" + this.ratio));
        }
        int O_origin = buf.pos();
        CustomByteArrayFrontCodedList decoder = new CustomByteArrayFrontCodedList(raba.iterator(), this.ratio, this.isDuplicateKeys());
        try {
            buf.write(0);
            buf.writeInt(size);
            buf.writeInt(this.ratio);
            decoder.getBackingBuffer().writeOn((OutputStream)buf);
            buf.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        AbstractFixedByteArrayBuffer slice = buf.slice(O_origin, buf.pos() - O_origin);
        return new CodedRabaImpl(slice, decoder);
    }

    @Override
    public AbstractFixedByteArrayBuffer encode(IRaba raba, DataOutputBuffer buf) {
        return this.encodeLive(raba, buf).data();
    }

    @Override
    public ICodedRaba decode(AbstractFixedByteArrayBuffer data) {
        return new CodedRabaImpl(data, this.isDuplicateKeys());
    }

    private static class CodedRabaImpl
    extends AbstractCodedRaba {
        private final AbstractFixedByteArrayBuffer data;
        private final CustomByteArrayFrontCodedList decoder;

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data, boolean hasDups) {
            byte version = data.getByte(0);
            if (version != 0) {
                throw new RuntimeException("Unknown version: " + version);
            }
            int size = data.getInt(1);
            int ratio = data.getInt(5);
            this.decoder = new CustomByteArrayFrontCodedList(size, ratio, data.array(), data.off() + 9, data.len(), hasDups);
            this.data = data;
        }

        public CodedRabaImpl(AbstractFixedByteArrayBuffer data, CustomByteArrayFrontCodedList decoder) {
            this.data = data;
            this.decoder = decoder;
        }

        @Override
        public AbstractFixedByteArrayBuffer data() {
            return this.data;
        }

        @Override
        public final boolean isKeys() {
            return true;
        }

        @Override
        public final int size() {
            return this.decoder.size();
        }

        @Override
        public final int capacity() {
            return this.decoder.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public final boolean isFull() {
            return true;
        }

        @Override
        public final boolean isNull(int index) {
            return false;
        }

        @Override
        public final byte[] get(int index) {
            return this.decoder.get(index);
        }

        @Override
        public final int length(int index) {
            return this.decoder.arrayLength(index);
        }

        @Override
        public int copy(int index, OutputStream os) {
            try {
                return this.decoder.writeOn(os, index);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Iterator<byte[]> iterator() {
            return this.decoder.iterator();
        }

        @Override
        public int search(byte[] searchKey) {
            return this.decoder.search(searchKey);
        }
    }

    public static class DefaultFrontCodedRabaCoder
    extends FrontCodedRabaCoder {
        private static final long serialVersionUID = 7300378339686013560L;
        public static final transient DefaultFrontCodedRabaCoder INSTANCE = new DefaultFrontCodedRabaCoder();
        protected static final transient int DEFAULT_RATIO = 8;

        public DefaultFrontCodedRabaCoder() {
            super(8);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }
}

