/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.proc;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;

public class BatchContains
extends AbstractKeyArrayIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBitBuffer>
implements IParallelizableIndexProcedure<AbstractKeyArrayIndexProcedure.ResultBitBuffer> {
    private static final long serialVersionUID = -5195874136364040815L;

    public BatchContains() {
    }

    protected BatchContains(IRabaCoder keysCoder, int fromIndex, int toIndex, byte[][] keys) {
        super(keysCoder, null, fromIndex, toIndex, keys, null);
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public AbstractKeyArrayIndexProcedure.ResultBitBuffer applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        int n = keys.size();
        boolean[] ret = new boolean[n];
        int onCount = 0;
        for (int i = 0; i < n; ++i) {
            ret[i] = ndx.contains(keys.get(i));
            if (!ret[i]) continue;
            ++onCount;
        }
        return new AbstractKeyArrayIndexProcedure.ResultBitBuffer(n, ret, onCount);
    }

    @Override
    protected IResultHandler<AbstractKeyArrayIndexProcedure.ResultBitBuffer, AbstractKeyArrayIndexProcedure.ResultBitBuffer> newAggregator() {
        AbstractKeyArrayIndexProcedure.ResultBitBufferHandler resultHandler = new AbstractKeyArrayIndexProcedure.ResultBitBufferHandler(this.getKeys().size());
        return resultHandler;
    }

    public static class BatchContainsConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<BatchContains> {
        public static final BatchContainsConstructor INSTANCE = new BatchContainsConstructor();

        private BatchContainsConstructor() {
        }

        @Override
        public final boolean sendValues() {
            return false;
        }

        @Override
        public BatchContains newInstance(IRabaCoder keysCoder, IRabaCoder valsCoder, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            if (vals != null) {
                throw new IllegalArgumentException("values must be null");
            }
            return new BatchContains(keysCoder, fromIndex, toIndex, keys);
        }
    }
}

