/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.keys;

import com.bigdata.btree.keys.CollatorEnum;
import com.bigdata.btree.keys.DecompositionEnum;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.ICUSortKeyGenerator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.JDKSortKeyGenerator;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.btree.keys.UnicodeSortKeyGenerator;
import com.bigdata.io.LongPacker;
import com.bigdata.util.BytesUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class KeyBuilder
implements IKeyBuilder,
LongPacker.IByteBuffer {
    private static final transient Logger log = Logger.getLogger(KeyBuilder.class);
    public static final transient int DEFAULT_INITIAL_CAPACITY = 1024;
    private int len;
    private byte[] buf;
    private final UnicodeSortKeyGenerator sortKeyGenerator;
    public final byte pad = (byte)32;
    private final byte[] pbuf = new byte[8];
    private static final byte decodeZero;
    private static final byte eos;
    private static final byte eos2;
    private static final byte negSign;
    private static final char[] flipMap;

    public KeyBuilder() {
        this(1024);
    }

    public KeyBuilder(int initialCapacity) {
        this(0, KeyBuilder.createBuffer(initialCapacity));
    }

    protected static byte[] createBuffer(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be non-negative");
        }
        int capacity = initialCapacity == 0 ? 1024 : initialCapacity;
        return new byte[capacity];
    }

    KeyBuilder(int len, byte[] buf) {
        this(null, len, buf);
    }

    protected KeyBuilder(UnicodeSortKeyGenerator sortKeyGenerator, int len, byte[] buf) {
        if (len < 0) {
            throw new IllegalArgumentException("len");
        }
        if (buf == null) {
            throw new IllegalArgumentException("buf");
        }
        if (len > buf.length) {
            throw new IllegalArgumentException("len>buf.length");
        }
        this.len = len;
        this.buf = buf;
        this.sortKeyGenerator = sortKeyGenerator;
    }

    @Override
    public final int off() {
        return 0;
    }

    @Override
    public final int len() {
        return this.len;
    }

    @Override
    public final byte[] array() {
        return this.buf;
    }

    @Override
    public final int capacity() {
        return this.buf.length;
    }

    public final void position(int pos) {
        if (this.len < 0 || this.len > this.buf.length) {
            throw new IndexOutOfBoundsException("pos=" + pos + ", but capacity=" + this.buf.length);
        }
        this.len = pos;
    }

    @Override
    public final KeyBuilder append(byte b) {
        return this.appendUnsigned(b);
    }

    @Override
    public final KeyBuilder append(byte[] a) {
        return this.append(a, 0, a.length);
    }

    @Override
    public final KeyBuilder append(byte[] a, int off, int len) {
        this.ensureFree(len);
        System.arraycopy(a, off, this.buf, this.len, len);
        this.len += len;
        return this;
    }

    @Override
    public final void ensureFree(int len) {
        this.ensureCapacity(this.len + len);
    }

    @Override
    public final void ensureCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        int overflow = capacity - this.buf.length;
        if (overflow > 0) {
            byte[] tmp = new byte[capacity];
            System.arraycopy(this.buf, 0, tmp, 0, this.len);
            this.buf = tmp;
        }
    }

    @Override
    public final byte[] toByteArray() {
        return this.getKey();
    }

    @Override
    public final byte[] getKey() {
        byte[] tmp = new byte[this.len];
        System.arraycopy(this.buf, 0, tmp, 0, this.len);
        return tmp;
    }

    @Override
    public final KeyBuilder reset() {
        this.len = 0;
        return this;
    }

    @Override
    public final boolean isUnicodeSupported() {
        return this.sortKeyGenerator != null;
    }

    public final UnicodeSortKeyGenerator getSortKeyGenerator() {
        return this.sortKeyGenerator;
    }

    @Override
    public final KeyBuilder append(String s) {
        if (this.sortKeyGenerator == null) {
            this.appendASCII(s);
        } else {
            this.sortKeyGenerator.appendSortKey(this, s);
        }
        return this;
    }

    @Override
    public KeyBuilder appendASCII(String s) {
        int tmpLen = s.length();
        this.ensureFree(tmpLen);
        for (int j = 0; j < tmpLen; ++j) {
            char ch = s.charAt(j);
            int v = ch;
            v = v < 0 ? (v -= 128) : (v += 128);
            this.buf[this.len++] = (byte)(v & 0xFF);
        }
        return this;
    }

    public static String decodeASCII(byte[] key, int off, int len) {
        byte[] b = new byte[len];
        System.arraycopy(key, off, b, 0, len);
        for (int i = 0; i < len; ++i) {
            b[i] = KeyBuilder.decodeByte(b[i]);
        }
        try {
            return new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    String normalizeText(String text) {
        if (text.length() > 65535) {
            text = text.substring(0, 65535);
        }
        int npadded = 0;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == ' '; --i) {
            ++npadded;
        }
        if (npadded > 0) {
            int begin = 0;
            int end = text.length() - npadded;
            text = text.substring(begin, end);
        }
        return text;
    }

    @Override
    public KeyBuilder appendText(String text, boolean unicode, boolean successor) {
        int textlen;
        int pos = this.len;
        text = this.normalizeText(text);
        if (unicode) {
            this.append(text);
        } else {
            this.appendASCII(text);
        }
        int encoded_len = this.len - pos;
        if (successor) {
            if (encoded_len == 0) {
                this.appendSigned((byte)33);
                textlen = 1;
            } else {
                SuccessorUtil.successor(this.buf, pos, encoded_len);
                textlen = text.length();
            }
        } else {
            textlen = text.length();
        }
        if (textlen < 65535) {
            this.appendUnsigned((byte)32);
            int runLength = 65535 - textlen;
            this.append((short)runLength);
        }
        return this;
    }

    @Override
    public final KeyBuilder append(double d) {
        long v;
        if (this.len + 8 > this.buf.length) {
            this.ensureCapacity(this.len + 8);
        }
        if ((v = Double.doubleToLongBits(d)) < 0L) {
            v = Long.MIN_VALUE - v;
        }
        return this.append(v);
    }

    public static double decodeDouble(byte[] key, int off) {
        long v = KeyBuilder.decodeLong(key, off);
        if (v < 0L) {
            v = Long.MIN_VALUE - v;
        }
        return Double.longBitsToDouble(v);
    }

    @Override
    public final KeyBuilder append(float f) {
        int v;
        if (this.len + 4 > this.buf.length) {
            this.ensureCapacity(this.len + 4);
        }
        if ((v = Float.floatToIntBits(f)) < 0) {
            v = Integer.MIN_VALUE - v;
        }
        return this.append(v);
    }

    public static float decodeFloat(byte[] key, int off) {
        int v = KeyBuilder.decodeInt(key, off);
        if (v < 0) {
            v = Integer.MIN_VALUE - v;
        }
        return Float.intBitsToFloat(v);
    }

    @Override
    public final KeyBuilder append(UUID uuid) {
        if (this.len + 16 > this.buf.length) {
            this.ensureCapacity(this.len + 16);
        }
        this.append(uuid.getMostSignificantBits());
        this.append(uuid.getLeastSignificantBits());
        return this;
    }

    @Override
    public final KeyBuilder append(long v) {
        if (this.len + 8 > this.buf.length) {
            this.ensureCapacity(this.len + 8);
        }
        v = v < 0L ? (v -= Long.MIN_VALUE) : (v += Long.MIN_VALUE);
        this.buf[this.len++] = (byte)(v >>> 56);
        this.buf[this.len++] = (byte)(v >>> 48);
        this.buf[this.len++] = (byte)(v >>> 40);
        this.buf[this.len++] = (byte)(v >>> 32);
        this.buf[this.len++] = (byte)(v >>> 24);
        this.buf[this.len++] = (byte)(v >>> 16);
        this.buf[this.len++] = (byte)(v >>> 8);
        this.buf[this.len++] = (byte)(v >>> 0);
        return this;
    }

    public final KeyBuilder pack(long v) {
        LongPacker.packLong(v, this.pbuf, this);
        return this;
    }

    @Override
    public void put(byte[] b, int off, int len) {
        this.ensureFree(len);
        System.arraycopy(b, 0, this.buf, this.len, len);
        this.len += len;
    }

    static final long encode(long v) {
        v = v < 0L ? (v -= Long.MIN_VALUE) : (v += Long.MIN_VALUE);
        return v;
    }

    @Override
    public final KeyBuilder append(int v) {
        if (this.len + 4 > this.buf.length) {
            this.ensureCapacity(this.len + 4);
        }
        v = v < 0 ? (v -= Integer.MIN_VALUE) : Integer.MIN_VALUE + v;
        this.buf[this.len++] = (byte)(v >>> 24);
        this.buf[this.len++] = (byte)(v >>> 16);
        this.buf[this.len++] = (byte)(v >>> 8);
        this.buf[this.len++] = (byte)(v >>> 0);
        return this;
    }

    @Override
    public final KeyBuilder append(short v) {
        if (this.len + 2 > this.buf.length) {
            this.ensureCapacity(this.len + 2);
        }
        v = v < 0 ? (short)(v - Short.MIN_VALUE) : (short)(Short.MIN_VALUE + v);
        this.buf[this.len++] = (byte)(v >>> 8);
        this.buf[this.len++] = (byte)(v >>> 0);
        return this;
    }

    public final KeyBuilder appendUnsigned(byte v) {
        if (this.len + 1 > this.buf.length) {
            this.ensureCapacity(this.len + 1);
        }
        this.buf[this.len++] = v;
        return this;
    }

    @Override
    public final KeyBuilder appendSigned(byte v) {
        int i;
        if (this.len + 1 > this.buf.length) {
            this.ensureCapacity(this.len + 1);
        }
        i = (i = v) < 0 ? (i -= 128) : (i += 128);
        this.buf[this.len++] = (byte)(i & 0xFF);
        return this;
    }

    @Override
    public final KeyBuilder appendNul() {
        if (this.len + 1 > this.buf.length) {
            this.ensureCapacity(this.len + 1);
        }
        this.buf[this.len++] = 0;
        return this;
    }

    @Override
    public KeyBuilder append(BigInteger i) {
        byte[] b = i.toByteArray();
        int runLength = i.signum() == -1 ? -b.length : b.length;
        this.ensureFree(b.length + 2);
        this.append((short)runLength);
        this.append(b);
        return this;
    }

    public static int byteLength(BigInteger value) {
        return 2 + (value.bitLength() / 8 + 1);
    }

    @Override
    public KeyBuilder append(BigDecimal d) {
        int sign = d.signum();
        if (sign == 0) {
            this.appendSigned((byte)0);
            return this;
        }
        BigDecimal nd = d.stripTrailingZeros();
        String unscaledStr = nd.unscaledValue().toString();
        int precision = nd.precision();
        int scale = nd.scale();
        int exponent = precision - scale;
        if (sign == -1) {
            exponent = -exponent;
        }
        this.appendSigned((byte)sign);
        this.append(exponent);
        if (sign == -1) {
            unscaledStr = KeyBuilder.flipDigits(unscaledStr);
        }
        this.appendASCII(unscaledStr);
        this.appendSigned(sign == -1 ? (byte)127 : 0);
        return this;
    }

    public static int byteLength(BigDecimal value) {
        int byteLength;
        if (value.signum() == 0) {
            byteLength = 1;
        } else {
            BigDecimal nbd = value.stripTrailingZeros();
            int dataLen = nbd.unscaledValue().toString().length();
            byteLength = 5 + dataLen + 1;
        }
        return byteLength;
    }

    @Override
    public byte[] getSortKey(Object val) {
        this.reset();
        this.append(val);
        return this.getKey();
    }

    @Override
    public KeyBuilder append(Object val) {
        if (val == null) {
            throw new IllegalArgumentException();
        }
        if (val instanceof byte[]) {
            this.append((byte[])val);
        } else if (val instanceof Byte) {
            this.appendSigned((Byte)val);
        } else {
            if (val instanceof Character) {
                throw new UnsupportedOperationException("Character is not supported.  Use Short or String depending on the semantics that you want.");
            }
            if (val instanceof Short) {
                this.append((Short)val);
            } else if (val instanceof Integer) {
                this.append((Integer)val);
            } else if (val instanceof Long) {
                this.append((Long)val);
            } else if (val instanceof BigInteger) {
                this.append((BigInteger)val);
            } else if (val instanceof BigDecimal) {
                this.append((BigDecimal)val);
            } else if (val instanceof Float) {
                this.append(((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.append((Double)val);
            } else if (val instanceof String) {
                this.append((String)val);
            } else if (val instanceof UUID) {
                this.append((UUID)val);
            } else {
                throw new UnsupportedOperationException("Can not encode key: " + val.getClass());
            }
        }
        return this;
    }

    public static byte encodeByte(int v) {
        int i = v;
        i = i < 0 ? (i -= 128) : (i += 128);
        return (byte)(i & 0xFF);
    }

    public static byte decodeByte(int v) {
        int i = v;
        i = i < 0 ? (i += 128) : (i -= 128);
        return (byte)(i & 0xFF);
    }

    public static long d2l(double d) {
        long aLong = Double.doubleToLongBits(d);
        if (aLong < 0L) {
            aLong = Long.MIN_VALUE - aLong;
        }
        return aLong;
    }

    public static int f2i(float f) {
        int aInt = Float.floatToIntBits(f);
        if (aInt < 0) {
            aInt = Integer.MIN_VALUE - aInt;
        }
        return aInt;
    }

    public static long decodeLong(byte[] buf, int off) {
        long v = 0L;
        v += (0xFFL & (long)buf[off++]) << 56;
        v += (0xFFL & (long)buf[off++]) << 48;
        v += (0xFFL & (long)buf[off++]) << 40;
        v += (0xFFL & (long)buf[off++]) << 32;
        v += (0xFFL & (long)buf[off++]) << 24;
        v += (0xFFL & (long)buf[off++]) << 16;
        v += (0xFFL & (long)buf[off++]) << 8;
        v = (v += (0xFFL & (long)buf[off++]) << 0) < 0L ? (v += Long.MIN_VALUE) : (v -= Long.MIN_VALUE);
        return v;
    }

    public static UUID decodeUUID(byte[] buf, int off) {
        long msb = KeyBuilder.decodeLong(buf, off);
        long lsb = KeyBuilder.decodeLong(buf, off += 8);
        return new UUID(msb, lsb);
    }

    public static int decodeInt(byte[] buf, int off) {
        int v = 0;
        v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 24));
        v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 16));
        v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 8));
        v = (v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 0))) < 0 ? (v += Integer.MIN_VALUE) : (v -= Integer.MIN_VALUE);
        return v;
    }

    public static short decodeShort(byte[] buf, int off) {
        int v = 0;
        v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 8));
        v = (v = (int)((long)v + ((0xFFL & (long)buf[off++]) << 0))) < 0 ? (v += 32768) : (v -= 32768);
        return (short)v;
    }

    public static BigInteger decodeBigInteger(int offset, byte[] key) {
        return new BigInteger(KeyBuilder.decodeBigInteger2(offset, key));
    }

    public static byte[] decodeBigInteger2(int offset, byte[] key) {
        short tmp = KeyBuilder.decodeShort(key, offset);
        short runLength = tmp < 0 ? -tmp : tmp;
        byte[] b = new byte[runLength];
        System.arraycopy(key, offset + 2, b, 0, runLength);
        return b;
    }

    public static BigDecimal decodeBigDecimal(int offset, byte[] key) {
        boolean neg;
        byte sign;
        int curs = offset;
        if ((sign = key[curs++]) == decodeZero) {
            return new BigDecimal(0);
        }
        int exponent = KeyBuilder.decodeInt(key, curs);
        boolean bl = neg = sign == negSign;
        if (neg) {
            exponent = -exponent;
        }
        int len = 0;
        int i = curs += 4;
        while (key[i] != (neg ? eos2 : eos)) {
            ++len;
            ++i;
        }
        String unscaledStr = KeyBuilder.decodeASCII(key, curs, len);
        if (neg) {
            unscaledStr = KeyBuilder.flipDigits(unscaledStr);
        }
        BigInteger unscaled = new BigInteger(unscaledStr);
        int precision = len;
        int scale = precision - exponent - (neg ? 1 : 0);
        BigDecimal ret = new BigDecimal(unscaled, scale);
        return ret;
    }

    private static String flipDigits(String str) {
        char[] chrs = str.toCharArray();
        for (int i = 0; i < chrs.length; ++i) {
            int flip = 57 - chrs[i];
            if (flip < 0 || flip >= 10) continue;
            chrs[i] = flipMap[flip];
        }
        return new String(chrs);
    }

    public static IKeyBuilder newInstance() {
        return KeyBuilder.newInstance(1024);
    }

    public static IKeyBuilder newInstance(int initialCapacity) {
        return KeyBuilder.newInstance(initialCapacity, CollatorEnum.ASCII, null, null, null);
    }

    public static IKeyBuilder newUnicodeInstance() {
        return new DefaultKeyBuilderFactory(null).getKeyBuilder();
    }

    public static IKeyBuilder newUnicodeInstance(Properties properties) {
        return new DefaultKeyBuilderFactory(properties).getKeyBuilder();
    }

    public static IKeyBuilder newInstance(int capacity, CollatorEnum collatorChoice, Locale locale, Object strength, DecompositionEnum mode) {
        boolean icu;
        if (collatorChoice == CollatorEnum.ASCII) {
            return new KeyBuilder(capacity);
        }
        if (locale == null) {
            locale = Locale.getDefault();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using default locale: " + locale.getDisplayName()));
            }
        }
        boolean bl = icu = collatorChoice == CollatorEnum.ICU;
        if (icu && !DefaultKeyBuilderFactory.isICUAvailable()) {
            throw new UnsupportedOperationException("The ICU library is not available.");
        }
        byte[] buf = KeyBuilder.createBuffer(capacity);
        boolean len = false;
        switch (collatorChoice) {
            case ICU: {
                return new KeyBuilder(new ICUSortKeyGenerator(locale, strength, mode), 0, buf);
            }
            case JDK: {
                return new KeyBuilder(new JDKSortKeyGenerator(locale, strength, mode), 0, buf);
            }
        }
        throw new UnsupportedOperationException("Collator not supported: " + (Object)((Object)collatorChoice));
    }

    @Override
    public byte[] toZOrder(int numDimensions) {
        int bytesTotal = 8 * numDimensions;
        byte[] zOrderArr = new byte[bytesTotal];
        for (int dimIt = 0; dimIt < numDimensions; ++dimIt) {
            int offset = dimIt * 64;
            int bufIt = 0;
            while (bufIt < 64) {
                if (this.buf[(bufIt + offset) / 8] != 0) {
                    BytesUtil.setBit((byte[])zOrderArr, (long)(bufIt * numDimensions + (numDimensions - 1 - dimIt)), (boolean)BytesUtil.getBit((byte[])this.buf, (long)(bufIt + offset)));
                    ++bufIt;
                    continue;
                }
                bufIt += 8;
            }
        }
        return zOrderArr;
    }

    @Override
    public long[] fromZOrder(int numDimensions) {
        int bytesTotal = 8 * numDimensions;
        byte[] componentArr = new byte[bytesTotal];
        int bufIt = 0;
        while (bufIt < 64 * numDimensions) {
            if (this.buf[bufIt / 8] != 0) {
                int dimension = bufIt % numDimensions;
                int bitPos = bufIt / numDimensions + dimension * 64;
                BytesUtil.setBit((byte[])componentArr, (long)bitPos, (boolean)BytesUtil.getBit((byte[])this.buf, (long)bufIt));
                ++bufIt;
                continue;
            }
            bufIt += 8;
        }
        long[] ret = new long[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            ret[numDimensions - 1 - i] = KeyBuilder.decodeLong(componentArr, i * 8);
        }
        return ret;
    }

    static {
        eos = decodeZero = KeyBuilder.decodeByte(0);
        eos2 = KeyBuilder.decodeByte(127);
        negSign = KeyBuilder.decodeByte(-1);
        flipMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    }

    public static interface Options {
        public static final String COLLATOR = KeyBuilder.class.getName() + ".collator";
        public static final String STRENGTH = KeyBuilder.class.getName() + ".collator.strength";
        public static final String DECOMPOSITION = KeyBuilder.class.getName() + ".collator.decomposition";
        public static final String USER_LANGUAGE = "user.language";
        public static final String USER_COUNTRY = "user.country";
        public static final String USER_VARIANT = "user.variant";
    }
}

