/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.isolation;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.ICounter;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.Tuple;
import com.bigdata.btree.isolation.IConflictResolver;
import com.bigdata.btree.view.FusedView;
import com.bigdata.journal.TimestampUtility;

public class IsolatedFusedView
extends FusedView {
    private final long startTime;
    private final BTree writeSet;

    public BTree getWriteSet() {
        return this.writeSet;
    }

    public IsolatedFusedView(long timestamp, AbstractBTree[] sources) {
        super(sources);
        if (!TimestampUtility.isCommitTime(timestamp)) {
            throw new IllegalStateException();
        }
        this.startTime = timestamp;
        if (sources.length < 2) {
            throw new IllegalArgumentException();
        }
        if (!(sources[0] instanceof BTree)) {
            throw new IllegalArgumentException();
        }
        this.writeSet = (BTree)sources[0];
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].getIndexMetadata().getVersionTimestamps()) continue;
            throw new IllegalArgumentException();
        }
    }

    public boolean isEmptyWriteSet() {
        return this.writeSet.getEntryCount() == 0L;
    }

    @Override
    public final ICounter getCounter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] insert(byte[] key, byte[] val) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getLookupTuple());
        if (tuple == null) {
            this.getMutableBTree().insert(key, val, false, false, this.startTime, null);
            return null;
        }
        long timestamp = tuple.getVersionTimestamp();
        this.getMutableBTree().insert(key, val, false, false, timestamp, null);
        return tuple.isNull() || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    @Override
    public byte[] putIfAbsent(byte[] key, byte[] val) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getLookupTuple());
        if (tuple == null) {
            this.getMutableBTree().insert(key, val, false, false, this.startTime, null);
            return null;
        }
        long timestamp = tuple.getVersionTimestamp();
        this.getMutableBTree().insert(key, val, false, true, timestamp, null);
        return tuple.isNull() || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    @Override
    public byte[] remove(byte[] key) {
        Tuple tuple = this.lookup(key, this.getMutableBTree().getLookupTuple());
        if (tuple == null) {
            this.getMutableBTree().insert(key, null, true, false, this.startTime, null);
            return null;
        }
        long timestamp = tuple.getVersionTimestamp();
        if (!tuple.isDeletedVersion() || timestamp != this.startTime) {
            this.getMutableBTree().insert(key, null, true, false, timestamp, null);
        }
        return tuple.isNull() || tuple.isDeletedVersion() ? null : tuple.getValue();
    }

    public boolean validate(AbstractBTree[] groundStateSources) {
        if (this.isEmptyWriteSet()) {
            return true;
        }
        IConflictResolver conflictResolver = this.writeSet.getIndexMetadata().getConflictResolver();
        AbstractBTree tmp = null;
        ILocalBTreeView groundState = groundStateSources.length == 1 ? groundStateSources[0] : new FusedView(groundStateSources);
        ITupleIterator itr = this.writeSet.rangeIterator(null, null, 0, 7, null);
        Tuple groundStateTuple = new Tuple(((ILocalBTreeView)groundState).getMutableBTree(), 3);
        while (itr.hasNext()) {
            ITuple txEntry = itr.next();
            byte[] key = txEntry.getKey();
            Tuple baseEntry = groundState instanceof AbstractBTree ? ((AbstractBTree)groundState).lookup(key, groundStateTuple) : ((FusedView)groundState).lookup(key, groundStateTuple);
            if (baseEntry == null || baseEntry.getVersionTimestamp() == txEntry.getVersionTimestamp()) continue;
            if (conflictResolver == null) {
                log.warn((Object)"Write-write conflict - no conflict resolver");
                return false;
            }
            if (tmp == null) {
                tmp = BTree.create(this.writeSet.getStore(), this.writeSet.getIndexMetadata().clone());
            }
            try {
                if (conflictResolver.resolveConflict(tmp, txEntry, baseEntry)) continue;
                log.warn((Object)"Write-write conflict NOT resolved.");
                return false;
            }
            catch (Exception ex) {
                log.error((Object)"Write-write conflict", (Throwable)ex);
                return false;
            }
        }
        if (tmp != null) {
            ITupleIterator tmpItr = tmp.rangeIterator(null, null, 0, 7, null);
            while (tmpItr.hasNext()) {
                ITuple tuple = tmpItr.next();
                if (tuple.isDeletedVersion()) {
                    this.writeSet.insert(tuple.getKey(), null, true, false, this.startTime, null);
                    continue;
                }
                this.writeSet.insert(tuple.getKey(), tuple.getValue(), false, false, this.startTime, null);
            }
        }
        return true;
    }

    public void mergeDown(long revisionTime, AbstractBTree[] groundStateSources) {
        ILocalBTreeView groundState = groundStateSources.length == 1 ? groundStateSources[0] : new FusedView(groundStateSources);
        BTree groundStateWriteSet = (BTree)groundStateSources[0];
        ITupleIterator itr = this.writeSet.rangeIterator(null, null, 0, 7, null);
        while (itr.hasNext()) {
            ITuple entry = itr.next();
            byte[] key = entry.getKey();
            if (entry.isDeletedVersion()) {
                if (!groundState.contains(key)) continue;
                groundStateWriteSet.insert(key, null, true, false, revisionTime, null);
                continue;
            }
            groundStateWriteSet.insert(key, entry.getValue(), false, false, revisionTime, null);
        }
    }
}

