/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.KeyAfterPartitionException;
import com.bigdata.btree.KeyBeforePartitionException;
import com.bigdata.mdi.ISeparatorKeys;
import com.bigdata.util.BytesUtil;

public class RangeCheckUtil {
    public static boolean rangeCheck(ISeparatorKeys pmd, byte[] key, boolean allowUpperBound) {
        byte[] leftSeparatorKey = pmd.getLeftSeparatorKey();
        byte[] rightSeparatorKey = pmd.getRightSeparatorKey();
        if (BytesUtil.compareBytes((byte[])key, (byte[])leftSeparatorKey) < 0) {
            throw new KeyBeforePartitionException(key, allowUpperBound, pmd);
        }
        if (rightSeparatorKey != null) {
            int ret = BytesUtil.compareBytes((byte[])key, (byte[])rightSeparatorKey);
            if (allowUpperBound) {
                if (ret > 0) {
                    throw new KeyAfterPartitionException(key, allowUpperBound, pmd);
                }
            } else if (ret >= 0) {
                throw new KeyAfterPartitionException(key, allowUpperBound, pmd);
            }
        }
        return true;
    }
}

