/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.htree.HTree;
import com.bigdata.io.LongPacker;
import com.bigdata.journal.IIndexManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.UUID;

public class HTreeIndexMetadata
extends IndexMetadata {
    private static final long serialVersionUID = -1L;
    private String htreeClassName;
    private int addressBits;
    private int keyLen;
    private static final transient int VERSION0 = 0;
    private static final transient int CURRENT_VERSION = 0;

    public final String getHTreeClassName() {
        return this.htreeClassName;
    }

    public void setHTreeClassName(String className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        this.htreeClassName = className;
    }

    public int getAddressBits() {
        return this.addressBits;
    }

    public void setAddressBits(int addressBits) {
        this.addressBits = addressBits;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public void setKeyLen(int keyLen) {
        this.keyLen = keyLen;
    }

    public HTreeIndexMetadata() {
    }

    public HTreeIndexMetadata(UUID indexUUID) {
        this(null, indexUUID);
    }

    public HTreeIndexMetadata(String name, UUID indexUUID) {
        this(null, System.getProperties(), name, indexUUID);
    }

    public HTreeIndexMetadata(IIndexManager indexManager, Properties properties, String namespace, UUID indexUUID) {
        super(indexManager, properties, namespace, indexUUID, IndexTypeEnum.HTree);
        this.htreeClassName = this.getProperty(indexManager, properties, namespace, Options.HTREE_CLASS_NAME, HTree.class.getName()).intern();
        this.addressBits = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.HTREE_ADDRESS_BITS, "10"));
        this.keyLen = Integer.parseInt(this.getProperty(indexManager, properties, namespace, Options.HTREE_KEY_LEN, "0"));
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", htreeClassName=" + this.htreeClassName);
        sb.append(", addressBits=" + this.addressBits);
        sb.append(", keyLen=" + this.keyLen);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int version = LongPacker.unpackInt(in);
        this.keyLen = LongPacker.unpackInt(in);
        this.addressBits = LongPacker.unpackInt(in);
        this.htreeClassName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        boolean version = false;
        LongPacker.packLong(out, 0L);
        LongPacker.packLong(out, (long)this.keyLen);
        LongPacker.packLong(out, (long)this.addressBits);
        out.writeUTF(this.htreeClassName);
    }

    @Override
    public HTreeIndexMetadata clone() {
        return (HTreeIndexMetadata)super.clone();
    }

    public static interface Options
    extends IndexMetadata.Options {
        public static final String HTREE_CLASS_NAME = HTree.class.getName() + ".className";
        public static final String HTREE_ADDRESS_BITS = HTree.class.getPackage().getName() + ".addressBits";
        public static final String DEFAULT_HTREE_ADDRESS_BITS = "10";
        public static final String HTREE_KEY_LEN = HTree.class.getPackage().getName() + ".keyLen";
        public static final String DEFAULT_HTREE_KEY_LEN = "0";
    }
}

