/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.HTreeIndexMetadata;
import com.bigdata.btree.ICheckpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import java.io.PrintWriter;
import java.util.Map;

public class BaseIndexStats {
    public IndexTypeEnum indexType;
    public String name;
    public int m;
    public long ntuples;
    public int height;
    public long nnodes;
    public long nleaves;

    public BaseIndexStats() {
    }

    public BaseIndexStats(ICheckpointProtocol ndx) {
        if (ndx == null) {
            throw new IllegalArgumentException();
        }
        ICheckpoint checkpoint = ndx.getCheckpoint();
        IndexMetadata metadata = ndx.getIndexMetadata();
        this.indexType = checkpoint.getIndexType();
        this.name = metadata.getName();
        switch (this.indexType) {
            case BTree: {
                this.m = metadata.getBranchingFactor();
                break;
            }
            case HTree: {
                this.m = ((HTreeIndexMetadata)metadata).getAddressBits();
                break;
            }
            case Stream: {
                this.m = 0;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown indexType=" + (Object)((Object)this.indexType)));
            }
        }
        this.height = checkpoint.getHeight();
        this.ntuples = checkpoint.getEntryCount();
        this.nnodes = checkpoint.getNodeCount();
        this.nleaves = checkpoint.getLeafCount();
    }

    public String getHeaderRow() {
        StringBuilder sb = new StringBuilder();
        sb.append("name");
        sb.append('\t');
        sb.append("indexType");
        sb.append('\t');
        sb.append("m");
        sb.append('\t');
        sb.append("height");
        sb.append('\t');
        sb.append("nnodes");
        sb.append('\t');
        sb.append("nleaves");
        sb.append('\t');
        sb.append("nentries");
        return sb.toString();
    }

    public String getDataRow() {
        BaseIndexStats stats = this;
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('\t');
        sb.append((Object)this.indexType);
        sb.append('\t');
        sb.append(stats.m);
        sb.append('\t');
        sb.append(stats.height);
        sb.append('\t');
        sb.append(stats.nnodes);
        sb.append('\t');
        sb.append(stats.nleaves);
        sb.append('\t');
        sb.append(stats.ntuples);
        return sb.toString();
    }

    public static void writeOn(PrintWriter out, Map<String, BaseIndexStats> statsMap) {
        boolean first = true;
        for (Map.Entry<String, BaseIndexStats> e : statsMap.entrySet()) {
            String name = e.getKey();
            BaseIndexStats stats = e.getValue();
            if (stats == null) {
                out.println("name: " + name + " :: no statistics?");
                continue;
            }
            if (first) {
                out.println(stats.getHeaderRow());
                first = false;
            }
            out.println(stats.getDataRow());
        }
    }
}

