/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IBTreeStatistics;
import com.bigdata.btree.IBTreeUtilizationReport;
import java.io.Serializable;

public class BTreeUtilizationReport
implements IBTreeUtilizationReport,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int leafUtilization;
    private final int nodeUtilization;
    private final int totalUtilization;

    public BTreeUtilizationReport(IBTreeStatistics stats) {
        long nnodes = stats.getNodeCount();
        long nleaves = stats.getLeafCount();
        long nentries = stats.getEntryCount();
        long numNonRootNodes = nnodes + nleaves - 1L;
        int branchingFactor = stats.getBranchingFactor();
        this.nodeUtilization = (int)(nnodes == 0L ? 100L : 100L * numNonRootNodes / (nnodes * (long)branchingFactor));
        this.leafUtilization = (int)(nleaves == 0L ? 0L : 100L * nentries / (nleaves * (long)branchingFactor));
        this.totalUtilization = (this.nodeUtilization + this.leafUtilization) / 2;
    }

    @Override
    public int getLeafUtilization() {
        return this.leafUtilization;
    }

    @Override
    public int getNodeUtilization() {
        return this.nodeUtilization;
    }

    @Override
    public int getTotalUtilization() {
        return this.totalUtilization;
    }

    public String toString() {
        return super.toString() + "{leafUtil=" + this.leafUtilization + ",nodeUtil=" + this.nodeUtilization + ",totalUtil=" + this.totalUtilization + "}";
    }
}

