/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.IBTreeStatistics;
import com.bigdata.btree.IBTreeUtilizationReport;
import java.io.Serializable;

public class BTreeStatistics
implements IBTreeStatistics,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int m;
    private final int height;
    private final long nodeCount;
    private final long leafCount;
    private final long entryCount;
    private final IBTreeUtilizationReport utilReport;

    public BTreeStatistics(AbstractBTree btree) {
        this.m = btree.getBranchingFactor();
        this.height = btree.getHeight();
        this.nodeCount = btree.getNodeCount();
        this.leafCount = btree.getLeafCount();
        this.entryCount = btree.getEntryCount();
        this.utilReport = btree.getUtilization();
    }

    @Override
    public int getBranchingFactor() {
        return this.m;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public long getLeafCount() {
        return this.leafCount;
    }

    @Override
    public long getEntryCount() {
        return this.entryCount;
    }

    @Override
    public IBTreeUtilizationReport getUtilization() {
        return this.utilReport;
    }

    public String toString() {
        return super.toString() + "{m=" + this.m + ",entryCount=" + this.entryCount + ",height=" + this.height + ",leafCount=" + this.leafCount + ",nodeCount=" + this.nodeCount + ",utilReport=" + this.utilReport + "}";
    }
}

