/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.paths;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class ZeroLengthPathOp
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public ZeroLengthPathOp(ZeroLengthPathOp op) {
        super(op);
    }

    public ZeroLengthPathOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public ZeroLengthPathOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ZeroLengthPathTask(this, context));
    }

    private static class ZeroLengthPathTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IVariable<?> leftVar;
        private final IVariable<?> rightVar;
        private final IConstant<?> leftConst;
        private final IConstant<?> rightConst;

        ZeroLengthPathTask(ZeroLengthPathOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            IVariableOrConstant leftTerm = (IVariableOrConstant)op.getProperty(Annotations.LEFT_TERM);
            this.leftVar = leftTerm.isVar() ? (IVariable)leftTerm : null;
            this.leftConst = leftTerm.isConstant() ? (IConstant)leftTerm : null;
            IVariableOrConstant rightTerm = (IVariableOrConstant)op.getProperty(Annotations.RIGHT_TERM);
            this.rightVar = rightTerm.isVar() ? (IVariable)rightTerm : null;
            IConstant iConstant = this.rightConst = rightTerm.isConstant() ? (IConstant)rightTerm : null;
            if (this.leftConst != null && this.rightConst != null) {
                throw new IllegalArgumentException("must be a variable on at least one side");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            ICloseableIterator<IBindingSet[]> source = this.context.getSource();
            IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();
            try {
                while (source.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])source.next();
                    IBindingSet[] chunkOut = this.processChunk(chunk);
                    sink.add(chunkOut);
                }
                sink.flush();
                Void void_ = null;
                return void_;
            }
            finally {
                sink.close();
                source.close();
            }
        }

        private IBindingSet[] processChunk(IBindingSet[] chunk) {
            IBindingSet[] chunkOut = new IBindingSet[chunk.length];
            int j = 0;
            for (int i = 0; i < chunk.length; ++i) {
                IBindingSet bs = chunk[i].clone();
                Gearing gearing = this.getGearing(bs);
                if (gearing == null) {
                    return new IBindingSet[0];
                }
                if (bs.isBound(gearing.var)) {
                    if (!bs.get(gearing.var).equals(gearing.constant)) {
                        continue;
                    }
                } else {
                    bs.set(gearing.var, gearing.constant);
                }
                chunkOut[j++] = bs;
            }
            if (j != chunk.length) {
                IBindingSet[] tmp = new IBindingSet[j];
                System.arraycopy(chunkOut, 0, tmp, 0, j);
                return tmp;
            }
            return chunkOut;
        }

        private Gearing getGearing(IBindingSet bs) {
            if (this.leftConst != null) {
                return new Gearing(this.rightVar, this.leftConst);
            }
            if (this.rightConst != null) {
                return new Gearing(this.leftVar, this.rightConst);
            }
            if (bs.isBound(this.leftVar)) {
                return new Gearing(this.rightVar, bs.get(this.leftVar));
            }
            if (bs.isBound(this.rightVar)) {
                return new Gearing(this.leftVar, bs.get(this.rightVar));
            }
            return null;
        }

        private class Gearing {
            public final IVariable<?> var;
            public final IConstant<?> constant;

            public Gearing(IVariable<?> var, IConstant<?> constant) {
                this.var = var;
                this.constant = constant;
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String LEFT_TERM = Annotations.class.getName() + ".leftTerm";
        public static final String RIGHT_TERM = Annotations.class.getName() + ".rightTerm";
    }
}

