/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.rto;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.joinGraph.rto.EstimateEnum;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public abstract class SampleBase {
    private static final transient Logger log = Logger.getLogger(SampleBase.class);
    public final long estCard;
    public final int limit;
    public final EstimateEnum estimateEnum;
    private final AtomicReference<IBindingSet[]> sampleRef = new AtomicReference();

    public boolean isExact() {
        return this.estimateEnum == EstimateEnum.Exact;
    }

    public boolean isUnderflow() {
        return this.estimateEnum == EstimateEnum.Underflow;
    }

    public IBindingSet[] getSample() {
        return this.sampleRef.get();
    }

    void releaseSample() {
        if (this.sampleRef.getAndSet(null) != null && log.isTraceEnabled()) {
            log.trace((Object)("Released sample: " + this));
        }
    }

    public SampleBase(long estimatedCardinality, int limit, EstimateEnum estimateEnum, IBindingSet[] sample) {
        if (estimatedCardinality < 0L) {
            throw new IllegalArgumentException();
        }
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        if (estimateEnum == null) {
            throw new IllegalArgumentException();
        }
        if (sample == null) {
            throw new IllegalArgumentException();
        }
        this.estCard = estimatedCardinality;
        this.limit = limit;
        this.estimateEnum = estimateEnum;
        this.sampleRef.set(sample);
    }

    protected void toString(StringBuilder sb) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{estCard=" + this.estCard);
        sb.append(",limit=" + this.limit);
        sb.append(",estimateEnum=" + (Object)((Object)this.estimateEnum));
        IBindingSet[] tmp = this.sampleRef.get();
        sb.append(",sampleSize=" + (tmp != null ? Integer.valueOf(tmp.length) : "N/A"));
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }
}

