/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.rto;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.ap.SampleIndex;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.joinGraph.NoSolutionsException;
import com.bigdata.bop.joinGraph.PartitionedJoinGroup;
import com.bigdata.bop.joinGraph.rto.EdgeSample;
import com.bigdata.bop.joinGraph.rto.EstimateEnum;
import com.bigdata.bop.joinGraph.rto.EstimatedCardinalityComparator;
import com.bigdata.bop.joinGraph.rto.JoinGraph;
import com.bigdata.bop.joinGraph.rto.Path;
import com.bigdata.bop.joinGraph.rto.PathIds;
import com.bigdata.bop.joinGraph.rto.SampleBase;
import com.bigdata.bop.joinGraph.rto.Vertex;
import com.bigdata.bop.joinGraph.rto.VertexSample;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpRTO;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class JGraph {
    private static final String NA = "N/A";
    private static final transient Logger log = Logger.getLogger(JGraph.class);
    private final JoinGraph joinGraph;
    private final Vertex[] V;
    private final IConstraint[] C;
    private final SampleIndex.SampleType sampleType;

    public List<Vertex> getVertices() {
        return Collections.unmodifiableList(Arrays.asList(this.V));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JoinGraph");
        sb.append("{V=[");
        for (Vertex vertex : this.V) {
            sb.append("\nV[" + vertex.pred.getId() + "]=" + vertex);
        }
        sb.append("{C=[");
        for (Serializable serializable : this.C) {
            sb.append("\nC[" + serializable.getId() + "]=" + serializable);
        }
        sb.append("\n]}");
        return sb.toString();
    }

    public JGraph(JoinGraph joinGraph) {
        SampleIndex.SampleType sampleType;
        if (joinGraph == null) {
            throw new IllegalArgumentException();
        }
        this.joinGraph = joinGraph;
        IPredicate<?>[] v = joinGraph.getVertices();
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (v.length < 2) {
            throw new IllegalArgumentException();
        }
        this.V = new Vertex[v.length];
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == null) {
                throw new IllegalArgumentException();
            }
            this.V[i] = new Vertex(v[i]);
        }
        IConstraint[] constraints = joinGraph.getConstraints();
        if (constraints != null) {
            this.C = new IConstraint[constraints.length];
            for (int i = 0; i < constraints.length; ++i) {
                if (constraints[i] == null) {
                    throw new IllegalArgumentException();
                }
                this.C[i] = constraints[i];
            }
        } else {
            this.C = null;
        }
        if ((sampleType = joinGraph.getSampleType()) == null) {
            throw new IllegalArgumentException();
        }
        this.sampleType = sampleType;
    }

    public Path runtimeOptimizer(QueryEngine queryEngine, Map<PathIds, EdgeSample> edgeSamples) throws Exception, NoSolutionsException {
        Path selectedPath;
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        int limit = this.joinGraph.getLimit();
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        int nedges = this.joinGraph.getNEdges();
        if (nedges <= 0) {
            throw new IllegalArgumentException();
        }
        if (edgeSamples == null) {
            throw new IllegalArgumentException();
        }
        Path[] paths = this.round0(queryEngine, limit, nedges);
        int nvertices = this.V.length;
        int round = 1;
        int nunderflow = 0;
        while (paths.length > 0 && round < nvertices - 1) {
            for (int i = 0; i < 3 && (nunderflow = this.resamplePaths(queryEngine, limit, round, paths, edgeSamples)) != 0; ++i) {
                log.warn((Object)("Cardinality estimate underflow - resampling: round=" + round + ", npaths=" + paths.length + ", nunderflow=" + nunderflow + ", limit=" + limit + "\n" + JGraph.showTable(paths, null, edgeSamples)));
            }
            if (nunderflow > 0) {
                log.warn((Object)"Continuing: some paths have cardinality underflow!");
            }
            paths = this.expand(queryEngine, limit, round++, paths, edgeSamples);
        }
        if (paths.length == 0) {
            throw new NoSolutionsException();
        }
        if (paths.length != 1) {
            log.warn((Object)("Multiple paths exist: npaths=" + paths.length + ", nunderflow=" + nunderflow + "\n" + JGraph.showTable(paths, null, edgeSamples)));
            Path t = null;
            for (Path p : paths) {
                if (p.edgeSample.isUnderflow() || t != null && p.sumEstCard >= t.sumEstCard) continue;
                t = p;
            }
            if (t == null) {
                t = paths[0];
            }
            selectedPath = t;
        } else {
            selectedPath = paths[0];
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\n*** Selected join path: " + Arrays.toString(selectedPath.getVertexIds()) + "\n" + JGraph.showPath(selectedPath, edgeSamples)));
        }
        return selectedPath;
    }

    public int[] getOrder(Path p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        IPredicate<?>[] path = p.getPredicates();
        if (path.length != this.V.length) {
            throw new IllegalArgumentException("Wrong path length: #vertices=" + this.V.length + ", but path.length=" + path.length);
        }
        int[] order = new int[this.V.length];
        for (int i = 0; i < order.length; ++i) {
            boolean found = false;
            for (int j = 0; j < order.length; ++j) {
                if (path[i].getId() != this.V[j].pred.getId()) continue;
                order[i] = j;
                found = true;
                break;
            }
            if (found) continue;
            throw new RuntimeException("No such vertex: id=" + path[i].getId());
        }
        return order;
    }

    public Path[] chooseStartingPaths(int nedges, Path[] paths) {
        LinkedList<Path> tmp = new LinkedList<Path>();
        Arrays.sort(paths, 0, paths.length, EstimatedCardinalityComparator.INSTANCE);
        for (int i = 0; i < paths.length && i < nedges; ++i) {
            tmp.add(paths[i]);
        }
        return tmp.toArray(new Path[tmp.size()]);
    }

    public Path[] round0(QueryEngine queryEngine, int limit, int nedges) throws Exception {
        this.sampleAllVertices(queryEngine, limit);
        if (log.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("limit=" + limit + ", nedges=" + nedges);
            sb.append(", sampled vertices::\n");
            for (Vertex v : this.V) {
                if (v.sample == null) continue;
                sb.append("id=" + v.pred.getId() + " : ");
                sb.append(v.sample.toString());
                sb.append("\n");
            }
            log.info((Object)sb.toString());
        }
        Path[] a = this.estimateInitialEdgeWeights(queryEngine, limit);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n*** Initial Paths\n" + JGraph.showTable(a)));
        }
        Path[] paths_t0 = this.chooseStartingPaths(nedges, a);
        if (log.isInfoEnabled()) {
            log.info((Object)("\n*** Paths @ t0\n" + JGraph.showTable(paths_t0)));
        }
        LinkedHashSet<Vertex> initialVertexSet = new LinkedHashSet<Vertex>();
        for (Path x : paths_t0) {
            initialVertexSet.add(x.vertices[0]);
        }
        for (Vertex v : this.V) {
            if (initialVertexSet.contains(v)) continue;
            v.sample = null;
        }
        return paths_t0;
    }

    /*
     * WARNING - void declaration
     */
    protected int resamplePaths(QueryEngine queryEngine, int limitIn, int round, Path[] a, Map<PathIds, EdgeSample> edgeSamples) throws Exception {
        void var9_12;
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        if (limitIn <= 0) {
            throw new IllegalArgumentException();
        }
        if (round <= 0) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Re-sampling in-use vertices.");
        }
        LinkedHashMap<Vertex, AtomicInteger> vertexLimit = new LinkedHashMap<Vertex, AtomicInteger>();
        Path[] arr$ = a;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_12 < len$) {
            Path x = arr$[var9_12];
            int limit = x.getNewLimit(limitIn);
            Vertex v = x.vertices[0];
            AtomicInteger theLimit = (AtomicInteger)vertexLimit.get(v);
            if (theLimit == null) {
                theLimit = new AtomicInteger();
                vertexLimit.put(v, theLimit);
            }
            theLimit.set(limit);
            ++var9_12;
        }
        this.sampleVertices(queryEngine, vertexLimit);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Re-sampling in-use path segments.");
        }
        int nunderflow = 0;
        LinkedList<ResamplePathTask> tasks = new LinkedList<ResamplePathTask>();
        for (Path x : a) {
            tasks.add(new ResamplePathTask(queryEngine, x, limitIn, edgeSamples));
        }
        for (Callable callable : tasks) {
            if (!((Boolean)callable.call()).booleanValue()) continue;
            ++nunderflow;
        }
        return nunderflow;
    }

    public Path[] expand(QueryEngine queryEngine, int limitIn, int round, Path[] a, Map<PathIds, EdgeSample> edgeSamples) throws Exception {
        if (queryEngine == null) {
            throw new IllegalArgumentException();
        }
        if (limitIn <= 0) {
            throw new IllegalArgumentException();
        }
        if (round <= 0) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        edgeSamples = Collections.synchronizedMap(edgeSamples);
        if (log.isDebugEnabled()) {
            log.debug((Object)("round=" + round + ", #paths(in)=" + a.length));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expanding paths: #paths(in)=" + a.length));
        }
        LinkedList tmpAll = new LinkedList();
        LinkedList<ExpandPathTask> tasks = new LinkedList<ExpandPathTask>();
        for (Path x : a) {
            tasks.add(new ExpandPathTask(queryEngine, x, edgeSamples));
        }
        List futures = queryEngine.getIndexManager().getExecutorService().invokeAll(tasks);
        for (Future f : futures) {
            tmpAll.addAll((Collection)f.get());
        }
        Path[] paths_tp1 = tmpAll.toArray(new Path[tmpAll.size()]);
        Path[] paths_tp1_pruned = this.pruneJoinPaths(paths_tp1, edgeSamples);
        if (log.isDebugEnabled()) {
            log.info((Object)("\n*** round=" + round + ": paths{in=" + a.length + ",considered=" + paths_tp1.length + ",out=" + paths_tp1_pruned.length + "}\n" + JGraph.showTable(paths_tp1, paths_tp1_pruned)));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\n*** round=" + round + ": paths{in=" + a.length + ",considered=" + paths_tp1.length + ",out=" + paths_tp1_pruned.length + "}\n" + JGraph.showTable(paths_tp1_pruned)));
        }
        return paths_tp1_pruned;
    }

    public Vertex getVertex(int bopId) {
        for (Vertex v : this.V) {
            if (v.pred.getId() != bopId) continue;
            return v;
        }
        return null;
    }

    private void sampleAllVertices(QueryEngine queryEngine, int limit) {
        LinkedHashMap<Vertex, AtomicInteger> vertexLimit = new LinkedHashMap<Vertex, AtomicInteger>();
        for (Vertex v : this.V) {
            vertexLimit.put(v, new AtomicInteger(limit));
        }
        this.sampleVertices(queryEngine, vertexLimit);
    }

    private void sampleVertices(QueryEngine queryEngine, Map<Vertex, AtomicInteger> vertexLimit) {
        List futures;
        LinkedList<SampleVertexTask> tasks = new LinkedList<SampleVertexTask>();
        for (Map.Entry<Vertex, AtomicInteger> e : vertexLimit.entrySet()) {
            Vertex v = e.getKey();
            int limit = e.getValue().get();
            tasks.add(new SampleVertexTask(queryEngine, v, limit, this.sampleType));
        }
        try {
            futures = queryEngine.getIndexManager().getExecutorService().invokeAll(tasks);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        LinkedList<Exception> causes = new LinkedList<Exception>();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                causes.add(e);
            }
            catch (ExecutionException e) {
                log.error((Object)e);
                causes.add(e);
            }
        }
        if (!causes.isEmpty()) {
            if (causes.size() == 1) {
                throw new RuntimeException((Throwable)causes.get(0));
            }
            throw new RuntimeException("nerrors=" + causes.size(), new ExecutionExceptions(causes));
        }
    }

    private Path[] estimateInitialEdgeWeights(QueryEngine queryEngine, int limit) throws Exception {
        LinkedList<CutoffJoinTask> tasks = new LinkedList<CutoffJoinTask>();
        boolean pathIsComplete = 2 == this.V.length;
        for (int i = 0; i < this.V.length; ++i) {
            Vertex v1 = this.V[i];
            if (v1.sample == null) continue;
            for (int j = i + 1; j < this.V.length; ++j) {
                Vertex vp;
                Vertex v;
                Vertex v2 = this.V[j];
                if (v2.sample == null) continue;
                if (v1.sample.estCard < v2.sample.estCard) {
                    v = v1;
                    vp = v2;
                } else {
                    v = v2;
                    vp = v1;
                }
                if (!PartitionedJoinGroup.canJoinUsingConstraints(new IPredicate[]{v.pred}, vp.pred, this.C)) continue;
                tasks.add(new CutoffJoinTask(queryEngine, limit, v, vp, pathIsComplete));
            }
        }
        LinkedList paths = new LinkedList();
        List futures = queryEngine.getIndexManager().getExecutorService().invokeAll(tasks);
        for (Future f : futures) {
            paths.add(f.get());
        }
        return paths.toArray(new Path[paths.size()]);
    }

    public Path[] pruneJoinPaths(Path[] a, Map<PathIds, EdgeSample> edgeSamples) {
        boolean neverPruneUnderflow = true;
        int maxPathLen = 0;
        for (Path p : a) {
            if (p.vertices.length <= maxPathLen) continue;
            maxPathLen = p.vertices.length;
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        LinkedHashSet<Path> pruned = new LinkedHashSet<Path>();
        for (int i = 0; i < a.length; ++i) {
            Path Pi = a[i];
            if (Pi.edgeSample == null) {
                throw new RuntimeException("Not sampled: " + Pi);
            }
            if (Pi.vertices.length < maxPathLen) {
                pruned.add(Pi);
                continue;
            }
            if (pruned.contains(Pi) || Pi.edgeSample.estimateEnum == EstimateEnum.Underflow) continue;
            for (int j = 0; j < a.length; ++j) {
                boolean isPiSuperSet;
                if (i == j) continue;
                Path Pj = a[j];
                if (Pj.edgeSample == null) {
                    throw new RuntimeException("Not sampled: " + Pj);
                }
                if (pruned.contains(Pj) || !(isPiSuperSet = Pi.isUnorderedVariant(Pj))) continue;
                long costPi = Pi.sumEstCost;
                long costPj = Pj.sumEstCost;
                boolean lte = costPi <= costPj;
                LinkedList<Integer> prunedByThisPath = null;
                if (lte) {
                    prunedByThisPath = new LinkedList<Integer>();
                    if (pruned.add(Pj)) {
                        prunedByThisPath.add(j);
                    }
                    for (int k = 0; k < a.length; ++k) {
                        Path x = a[k];
                        if (!x.beginsWith(Pj) || !pruned.add(x)) continue;
                        prunedByThisPath.add(k);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                f.format("Comparing: P[%2d] with P[%2d] : %10d %2s %10d %s", i, j, costPi, lte ? "<=" : ">", costPj, lte ? " *** pruned " + prunedByThisPath : "");
                log.debug((Object)sb);
                sb.setLength(0);
            }
        }
        LinkedHashSet<Path> keep = new LinkedHashSet<Path>();
        for (Path p : a) {
            if (pruned.contains(p)) continue;
            keep.add(p);
        }
        Path[] b = keep.toArray(new Path[keep.size()]);
        Iterator<Map.Entry<PathIds, EdgeSample>> itr = edgeSamples.entrySet().iterator();
        int ncleared = 0;
        while (itr.hasNext()) {
            Map.Entry<PathIds, EdgeSample> e = itr.next();
            PathIds ids = e.getKey();
            boolean found = false;
            for (Path p : b) {
                if (!p.beginsWith(ids.ids)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Clearing sample: " + ids));
            }
            e.getValue().releaseSample();
            itr.remove();
            ++ncleared;
        }
        if (ncleared > 0 && log.isDebugEnabled()) {
            log.debug((Object)("Cleared " + ncleared + " samples"));
        }
        return b;
    }

    public static String showTable(Path[] a) {
        return JGraph.showTable(a, null);
    }

    public static String showTable(Path[] a, Path[] pruned) {
        return JGraph.showTable(a, pruned, null);
    }

    public static String showTable(Path[] a, Path[] pruned, Map<PathIds, EdgeSample> edgeSamples) {
        StringBuilder sb = new StringBuilder(128 * a.length);
        LinkedList<Path> underflowPaths = new LinkedList<Path>();
        Formatter f = new Formatter(sb);
        f.format("%-4s %10s%1s * %10s (%8s %8s %8s %8s %8s %8s) = %10s %10s%1s : %10s %10s %10s %10s", "path", "srcCard", "", "f", "in", "sumRgCt", "tplsRead", "out", "limit", "adjCard", "estRead", "estCard", "", "sumEstRead", "sumEstCard", "sumEstCost", "joinPath\n");
        for (int i = 0; i < a.length; ++i) {
            EdgeSample edgeSample;
            Path x = a[i];
            Boolean prune = null;
            if (pruned != null) {
                prune = Boolean.TRUE;
                for (Path y : pruned) {
                    if (y != x) continue;
                    prune = Boolean.FALSE;
                    break;
                }
            }
            if ((edgeSample = x.edgeSample) == null) {
                f.format("%4d %10s%1s * %10s (%8s %8s %8s %8s %8s %8s) = %10s %10s%1s : %10s %10s %10s", i, NA, "", NA, NA, NA, NA, NA, NA, NA, NA, NA, "", NA, NA, NA);
            } else {
                f.format("%4d %10d%1s * % 10.2f (%8d %8d %8d %8d %8d %8d) = %10d % 10d%1s : % 10d % 10d % 10d", i, edgeSample.sourceSample.estCard, edgeSample.sourceSample.estimateEnum.getCode(), edgeSample.f, edgeSample.inputCount, edgeSample.sumRangeCount, edgeSample.tuplesRead, edgeSample.outputCount, edgeSample.limit, edgeSample.adjCard, edgeSample.estRead, edgeSample.estCard, edgeSample.estimateEnum.getCode(), x.sumEstRead, x.sumEstCard, x.sumEstCost);
            }
            sb.append("  [");
            for (Vertex v : x.getVertices()) {
                f.format("%2d ", v.pred.getId());
            }
            sb.append("]");
            if (pruned != null && prune.booleanValue()) {
                sb.append(" pruned");
            }
            sb.append("\n");
            if (!x.edgeSample.isUnderflow()) continue;
            underflowPaths.add(x);
        }
        if (edgeSamples != null && !underflowPaths.isEmpty()) {
            sb.append("\nPaths with cardinality estimate underflow::\n");
            for (Path p : underflowPaths) {
                sb.append(JGraph.showPath(p, edgeSamples));
                sb.append("----\n");
            }
        }
        return sb.toString();
    }

    public static String showPath(Path x, Map<PathIds, EdgeSample> edgeSamples) {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (edgeSamples == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        f.format("%4s %10s%1s * %10s (%8s %8s %8s %8s %8s %8s) = %10s %10s%1s : %10s %10s", "vert", "srcCard", "", "f", "in", "sumRgCt", "tplsRead", "out", "limit", "adjCard", "estRead", "estCard", "", "sumEstRead", "sumEstCard");
        long sumEstRead = 0L;
        long sumEstCard = 0L;
        for (int i = 0; i < x.vertices.length; ++i) {
            SampleBase sample;
            int[] ids = BOpUtility.getPredIds(x.getPathSegment(i + 1));
            int predId = x.vertices[i].pred.getId();
            if (i == 0) {
                sample = x.vertices[i].sample;
                if (sample != null) {
                    sumEstRead = sample.estCard;
                    sumEstCard = sample.estCard;
                }
            } else {
                sample = edgeSamples.get(new PathIds(ids));
                if (sample != null) {
                    sumEstRead += ((EdgeSample)sample).estRead;
                    sumEstCard += ((EdgeSample)sample).estCard;
                }
            }
            sb.append("\n");
            if (sample == null) {
                f.format("% 4d %10s%1s * %10s (%8s %8s %8s %8s %8s %8s) = %10s %10s%1s : %10s %10s", predId, NA, "", NA, NA, NA, NA, NA, NA, NA, NA, NA, "", NA, NA);
                continue;
            }
            if (sample instanceof VertexSample) {
                long sumRangeCount = sample.estCard;
                long estRead = sample.estCard;
                long tuplesRead = Math.min(sample.estCard, (long)sample.limit);
                long outputCount = Math.min(sample.estCard, (long)sample.limit);
                long adjCard = Math.min(sample.estCard, (long)sample.limit);
                f.format("% 4d %10s%1s * %10s (%8s %8s %8s %8s %8s %8s) = % 10d % 10d%1s : %10d %10d", predId, " ", " ", " ", " ", sumRangeCount, tuplesRead, outputCount, sample.limit, adjCard, estRead, sample.estCard, sample.estimateEnum.getCode(), sumEstRead, sumEstCard);
                continue;
            }
            EdgeSample edgeSample = (EdgeSample)sample;
            f.format("% 4d %10d%1s * % 10.2f (%8d %8d %8d %8d %8d %8d) = % 10d % 10d%1s : %10d %10d", predId, edgeSample.sourceSample.estCard, edgeSample.sourceSample.estimateEnum.getCode(), edgeSample.f, edgeSample.inputCount, edgeSample.sumRangeCount, edgeSample.tuplesRead, edgeSample.outputCount, edgeSample.limit, edgeSample.adjCard, edgeSample.estRead, edgeSample.estCard, edgeSample.estimateEnum.getCode(), sumEstRead, sumEstCard);
        }
        sb.append("\n");
        return sb.toString();
    }

    private class CutoffJoinTask
    implements Callable<Path> {
        private final QueryEngine queryEngine;
        private final int limit;
        private final Vertex v;
        private final Vertex vp;
        private final boolean pathIsComplete;

        public CutoffJoinTask(QueryEngine queryEngine, int limit, Vertex v, Vertex vp, boolean pathIsComplete) {
            this.queryEngine = queryEngine;
            this.limit = limit;
            this.v = v;
            this.vp = vp;
            this.pathIsComplete = pathIsComplete;
        }

        @Override
        public Path call() throws Exception {
            IPredicate[] preds = new IPredicate[]{this.v.pred, this.vp.pred};
            EdgeSample edgeSample = AST2BOpRTO.cutoffJoin(this.queryEngine, JGraph.this.joinGraph, this.limit, preds, JGraph.this.C, this.pathIsComplete, this.v.sample);
            Path p = new Path(this.v, this.vp, edgeSample);
            return p;
        }
    }

    private static class SampleVertexTask
    implements Callable<Void> {
        private final QueryEngine queryEngine;
        private final Vertex v;
        private final int limit;
        private final SampleIndex.SampleType sampleType;

        public SampleVertexTask(QueryEngine queryEngine, Vertex v, int limit, SampleIndex.SampleType sampleType) {
            this.queryEngine = queryEngine;
            this.v = v;
            this.limit = limit;
            this.sampleType = sampleType;
        }

        @Override
        public Void call() throws Exception {
            this.v.sample(this.queryEngine, this.limit, this.sampleType);
            return null;
        }
    }

    private class ExpandPathTask
    implements Callable<List<Path>> {
        private final QueryEngine queryEngine;
        private final Path x;
        private final Map<PathIds, EdgeSample> edgeSamples;

        public ExpandPathTask(QueryEngine queryEngine, Path x, Map<PathIds, EdgeSample> edgeSamples) {
            this.queryEngine = queryEngine;
            this.x = x;
            this.edgeSamples = edgeSamples;
        }

        @Override
        public List<Path> call() throws Exception {
            int limit = this.x.edgeSample.limit;
            LinkedHashSet<Vertex> used = new LinkedHashSet<Vertex>();
            LinkedHashSet<Vertex> nothingShared = new LinkedHashSet<Vertex>();
            LinkedList<Path> tmp = new LinkedList<Path>();
            for (Vertex tVertex : JGraph.this.V) {
                boolean vFound = this.x.contains(tVertex);
                if (vFound) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Vertex: " + tVertex + " - already part of this path."));
                    continue;
                }
                if (used.contains(tVertex)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Vertex: " + tVertex + " - already used to extend this path."));
                    continue;
                }
                if (!PartitionedJoinGroup.canJoinUsingConstraints(this.x.getPredicates(), tVertex.pred, JGraph.this.C)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Vertex: " + tVertex + " - unconstrained join for this path."));
                    }
                    nothingShared.add(tVertex);
                    continue;
                }
                used.add(tVertex);
                Path p = this.x.addEdge(this.queryEngine, JGraph.this.joinGraph, limit, tVertex, JGraph.this.C, this.x.getVertexCount() + 1 == JGraph.this.V.length);
                tmp.add(p);
                if (this.edgeSamples.put(new PathIds(p.getVertexIds()), p.edgeSample) != null) {
                    throw new AssertionError();
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Extended path with dynamic edge: vnew=" + tVertex.pred.getId() + ", new path=" + p));
            }
            if (tmp.isEmpty()) {
                assert (!nothingShared.isEmpty());
                Vertex tVertex = (Vertex)nothingShared.iterator().next();
                Path p = this.x.addEdge(this.queryEngine, JGraph.this.joinGraph, limit, tVertex, JGraph.this.C, this.x.getVertexCount() + 1 == JGraph.this.V.length);
                tmp.add(p);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Extended path with dynamic edge: vnew=" + tVertex.pred.getId() + ", new path=" + p));
                }
            }
            return tmp;
        }
    }

    private class ResamplePathTask
    implements Callable<Boolean> {
        private final QueryEngine queryEngine;
        private final Path x;
        private final int limitIn;
        private final Map<PathIds, EdgeSample> edgeSamples;

        public ResamplePathTask(QueryEngine queryEngine, Path x, int limitIn, Map<PathIds, EdgeSample> edgeSamples) {
            this.queryEngine = queryEngine;
            this.x = x;
            this.limitIn = limitIn;
            this.edgeSamples = edgeSamples;
        }

        @Override
        public Boolean call() throws Exception {
            boolean underflow;
            int limit = this.x.getNewLimit(this.limitIn);
            EdgeSample priorEdgeSample = null;
            for (int segmentLength = 2; segmentLength <= this.x.vertices.length; ++segmentLength) {
                PathIds ids = new PathIds(BOpUtility.getPredIds(this.x.getPathSegment(segmentLength)));
                EdgeSample edgeSample = this.edgeSamples.get(ids);
                if (edgeSample != null && edgeSample.limit < limit && !edgeSample.isExact()) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Will resample at higher limit: " + ids));
                    }
                    this.edgeSamples.remove(ids);
                    edgeSample = null;
                }
                if (priorEdgeSample == null) {
                    assert (segmentLength == 2);
                    if (edgeSample == null && this.edgeSamples.put(ids, edgeSample = AST2BOpRTO.cutoffJoin(this.queryEngine, JGraph.this.joinGraph, limit, this.x.getPathSegment(2), JGraph.this.C, JGraph.this.V.length == 2, this.x.vertices[0].sample)) != null) {
                        throw new AssertionError();
                    }
                    priorEdgeSample = edgeSample;
                    continue;
                }
                assert (ids.length() >= 3);
                if (edgeSample == null) {
                    edgeSample = AST2BOpRTO.cutoffJoin(this.queryEngine, JGraph.this.joinGraph, limit, this.x.getPathSegment(ids.length()), JGraph.this.C, JGraph.this.V.length == ids.length(), priorEdgeSample);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Resampled: " + ids + " : " + edgeSample));
                    }
                    if (this.edgeSamples.put(ids, edgeSample) != null) {
                        throw new AssertionError();
                    }
                }
                priorEdgeSample = edgeSample;
            }
            if (priorEdgeSample == null) {
                throw new AssertionError();
            }
            this.x.edgeSample = priorEdgeSample;
            boolean bl = underflow = this.x.edgeSample.estimateEnum == EstimateEnum.Underflow;
            if (underflow && log.isDebugEnabled()) {
                log.debug((Object)("Cardinality underflow: " + this.x));
            }
            return underflow;
        }
    }
}

