/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.engine.IChunkAccessor;
import com.bigdata.bop.engine.IChunkMessage;
import com.bigdata.bop.engine.IQueryClient;
import com.bigdata.bop.fed.FederatedRunningQuery;
import com.bigdata.relation.accesspath.ThickCloseableIterator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.rmi.RemoteException;
import java.util.UUID;

public class LocalChunkMessage
implements IChunkMessage<IBindingSet> {
    private static final long serialVersionUID = 1L;
    private final IQueryClient queryController;
    private final UUID queryControllerId;
    private final UUID queryId;
    private final int bopId;
    private final int partitionId;
    private final int solutionCount;
    private IBindingSet[][] bindingSetChunks;
    private volatile transient ChunkAccessor chunkAccessor = null;

    @Override
    public IQueryClient getQueryController() {
        return this.queryController;
    }

    @Override
    public UUID getQueryControllerId() {
        return this.queryControllerId;
    }

    @Override
    public UUID getQueryId() {
        return this.queryId;
    }

    @Override
    public int getBOpId() {
        return this.bopId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isLastInvocation() {
        return false;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public int getSolutionCount() {
        return this.solutionCount;
    }

    public LocalChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IBindingSet bset) {
        this(queryController, queryId, bopId, partitionId, new IBindingSet[][]{{bset}});
    }

    public LocalChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IBindingSet[] bsets) {
        this(queryController, queryId, bopId, partitionId, new IBindingSet[][]{bsets});
    }

    public LocalChunkMessage(IQueryClient queryController, UUID queryId, int bopId, int partitionId, IBindingSet[][] bindingSetChunks) {
        if (queryController == null) {
            throw new IllegalArgumentException();
        }
        if (queryId == null) {
            throw new IllegalArgumentException();
        }
        if (bindingSetChunks == null) {
            throw new IllegalArgumentException();
        }
        this.queryController = queryController;
        try {
            this.queryControllerId = queryController.getServiceUUID();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.queryId = queryId;
        this.bopId = bopId;
        this.partitionId = partitionId;
        this.solutionCount = LocalChunkMessage.solutionCount(bindingSetChunks);
        this.bindingSetChunks = bindingSetChunks;
    }

    public String toString() {
        return this.getClass().getName() + "{queryId=" + this.queryId + ",bopId=" + this.bopId + ",partitionId=" + this.partitionId + ", solutionCount=" + this.solutionCount + "}";
    }

    @Override
    public void materialize(FederatedRunningQuery runningQuery) {
    }

    @Override
    public void release() {
        ChunkAccessor tmp = this.chunkAccessor;
        if (tmp != null) {
            tmp.close();
        }
        for (int i = 0; i < this.bindingSetChunks.length; ++i) {
            this.bindingSetChunks[i] = null;
        }
    }

    @Override
    public IChunkAccessor<IBindingSet> getChunkAccessor() {
        if (this.chunkAccessor == null) {
            this.chunkAccessor = new ChunkAccessor();
        }
        return this.chunkAccessor;
    }

    private static ThickCloseableIterator<IBindingSet[]> newBindingSetIterator(IBindingSet[][] bindingSetChunks) {
        return new ThickCloseableIterator<IBindingSet[]>((E[])bindingSetChunks);
    }

    private static int solutionCount(IBindingSet[][] bindingSetChunks) {
        int solutionCount = 0;
        for (int i = 0; i < bindingSetChunks.length; ++i) {
            solutionCount += bindingSetChunks[i].length;
        }
        return solutionCount;
    }

    private class ChunkAccessor
    implements IChunkAccessor<IBindingSet> {
        private final ICloseableIterator<IBindingSet[]> source;

        public ChunkAccessor() {
            this.source = LocalChunkMessage.newBindingSetIterator(LocalChunkMessage.this.bindingSetChunks);
        }

        @Override
        public ICloseableIterator<IBindingSet[]> iterator() {
            return this.source;
        }

        public void close() {
            this.source.close();
        }
    }
}

