/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.BigdataFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileVersionOutputStream
extends OutputStream {
    protected final BigdataFileSystem repo;
    protected final String id;
    protected final int version;
    private final byte[] buffer;
    private int len = 0;
    private long nwritten;
    private long nblocks;

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public long getByteCount() {
        return this.nwritten;
    }

    public long getBlockCount() {
        return this.nblocks;
    }

    public FileVersionOutputStream(BigdataFileSystem repo, String id, int version) {
        if (repo == null) {
            throw new IllegalArgumentException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.repo = repo;
        this.id = id;
        this.version = version;
        this.buffer = new byte[repo.getBlockSize()];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.len == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.len++] = (byte)(b & 0xFF);
        ++this.nwritten;
    }

    @Override
    public void flush() throws IOException {
        if (this.len > 0) {
            BigdataFileSystem.log.info((Object)("Flushing buffer: id=" + this.id + ", version=" + this.version + ", len=" + this.len));
            this.repo.appendBlock(this.id, this.version, this.buffer, 0, this.len);
            this.len = 0;
            ++this.nblocks;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public long copyStream(InputStream is) throws IOException {
        long ncopied = 0L;
        while (true) {
            int remainder;
            int off;
            int nread;
            if (this.len == this.buffer.length) {
                this.flush();
            }
            if ((nread = is.read(this.buffer, off = this.len, remainder = this.buffer.length - off)) == -1) {
                BigdataFileSystem.log.info((Object)("Copied " + ncopied + " bytes: id=" + this.id + ", version=" + this.version));
                try {
                    is.close();
                }
                catch (IOException ex) {
                    BigdataFileSystem.log.warn((Object)("Problem closing input stream: id=" + this.id + ", version=" + this.version), (Throwable)ex);
                }
                return ncopied;
            }
            this.len = off + nread;
            ncopied += (long)nread;
            this.nwritten += (long)nread;
        }
    }
}

