/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import org.jooq.Block;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DSLContext;
import org.jooq.Queries;
import org.jooq.Query;
import org.jooq.ResultQuery;
import org.jooq.Results;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ResultsImpl;
import org.jooq.impl.Tools;

final class QueriesImpl
extends AbstractQueryPart
implements Queries {
    private static final long serialVersionUID = 261452207127914269L;
    private final Collection<? extends Query> queries;
    private Configuration configuration;

    QueriesImpl(Configuration configuration, Collection<? extends Query> queries) {
        this.configuration = configuration;
        this.queries = queries;
    }

    @Override
    public final Queries concat(Queries other) {
        Query[] array = other.queries();
        ArrayList<? extends Query> list = new ArrayList<Query>(this.queries.size() + array.length);
        list.addAll(this.queries);
        list.addAll(Arrays.asList(array));
        return new QueriesImpl(this.configuration, list);
    }

    @Override
    public final Query[] queries() {
        return this.queries.toArray(Tools.EMPTY_QUERY);
    }

    @Override
    public final Block block() {
        return this.configuration.dsl().begin(this.queries);
    }

    @Override
    public final Iterator<Query> iterator() {
        return this.queries.iterator();
    }

    @Override
    public final Stream<Query> stream() {
        return this.queryStream();
    }

    @Override
    public final Stream<Query> queryStream() {
        return this.queries.stream();
    }

    @Override
    public final Results fetchMany() {
        ResultsImpl results = new ResultsImpl(this.configuration());
        DSLContext ctx = this.configuration().dsl();
        for (Query query : this) {
            if (query instanceof ResultQuery) {
                results.resultsOrRows.addAll(ctx.fetchMany((ResultQuery)query).resultsOrRows());
                continue;
            }
            results.resultsOrRows.add(new ResultsImpl.ResultOrRowsImpl(ctx.execute(query)));
        }
        return results;
    }

    @Override
    public final int[] executeBatch() {
        return this.configuration().dsl().batch(this).execute();
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean first = true;
        for (Query query : this) {
            if (first) {
                first = false;
            } else {
                ctx.formatSeparator();
            }
            ctx.visit(query).sql(';');
        }
    }

    @Override
    public int hashCode() {
        return this.queries.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueriesImpl)) {
            return false;
        }
        return this.queries.equals(((QueriesImpl)obj).queries);
    }
}

