/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.CaseConditionStep;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.Tools;

final class Decode<T, Z>
extends AbstractField<Z> {
    private static final long serialVersionUID = -7273879239726265322L;
    private final Field<T> field;
    private final Field<T> search;
    private final Field<Z> result;
    private final Field<?>[] more;

    public Decode(Field<T> field, Field<T> search, Field<Z> result, Field<?>[] more) {
        super(Names.N_DECODE, result.getDataType());
        this.field = field;
        this.search = search;
        this.result = result;
        this.more = more;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(DSL.function("decode", this.getDataType(), Tools.combine(this.field, this.search, this.result, this.more)));
                return;
            }
        }
        CaseConditionStep<Z> when = DSL.choose().when(this.field.isNotDistinctFrom(this.search), this.result);
        for (int i = 0; i < this.more.length; i += 2) {
            if (i + 1 >= this.more.length) {
                ctx.visit(when.otherwise(this.more[i]));
                return;
            }
            when = when.when(this.field.isNotDistinctFrom(this.more[i]), this.more[i + 1]);
        }
        ctx.visit(when);
    }
}

