/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.Tools;

final class CompareCondition
extends AbstractCondition
implements LikeEscapeStep {
    private static final long serialVersionUID = -747240442279619486L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private static final Set<SQLDialect> REQUIRES_CAST_ON_LIKE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.POSTGRES);
    private static final Set<SQLDialect> NO_SUPPORT_ILIKE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    final Field<?> field1;
    final Field<?> field2;
    final Comparator comparator;
    private Character escape;

    CompareCondition(Field<?> field1, Field<?> field2, Comparator comparator) {
        this.field1 = field1;
        this.field2 = field2;
        this.comparator = comparator;
    }

    @Override
    public final Condition escape(char c) {
        this.escape = Character.valueOf(c);
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean field1Embeddable = this.field1.getDataType().isEmbeddable();
        if (field1Embeddable && this.field2 instanceof ScalarSubquery) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.field1)).compare(this.comparator, ((ScalarSubquery)this.field2).query));
        } else if (field1Embeddable && this.field2.getDataType().isEmbeddable()) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.field1)).compare(this.comparator, Tools.embeddedFields(this.field2)));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ParamType previousParamType;
        SQLDialect family = ctx.family();
        Field<Object> lhs = this.field1;
        Field<Object> rhs = this.field2;
        Comparator op = this.comparator;
        if ((op == Comparator.LIKE || op == Comparator.NOT_LIKE || op == Comparator.SIMILAR_TO || op == Comparator.NOT_SIMILAR_TO) && this.field1.getType() != String.class && REQUIRES_CAST_ON_LIKE.contains((Object)ctx.dialect())) {
            lhs = Tools.castIfNeeded(lhs, String.class);
        } else if ((op == Comparator.LIKE_IGNORE_CASE || op == Comparator.NOT_LIKE_IGNORE_CASE) && NO_SUPPORT_ILIKE.contains((Object)ctx.dialect())) {
            lhs = lhs.lower();
            rhs = rhs.lower();
            op = op == Comparator.LIKE_IGNORE_CASE ? Comparator.LIKE : Comparator.NOT_LIKE;
        }
        ctx.visit(lhs).sql(' ');
        boolean castRhs = false;
        ParamType forcedParamType = previousParamType = ctx.paramType();
        ctx.visit(op.toKeyword()).sql(' ');
        if (castRhs) {
            ctx.visit(Keywords.K_CAST).sql('(');
        }
        ctx.paramType(forcedParamType).visit(rhs).paramType(previousParamType);
        if (castRhs) {
            ctx.sql(' ').visit(Keywords.K_AS).sql(' ').visit(Keywords.K_VARCHAR).sql("(4000))");
        }
        if (this.escape != null) {
            ctx.sql(' ').visit(Keywords.K_ESCAPE).sql(' ').visit(DSL.inline(this.escape));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

