/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.coode.owlapi.obo12.parser.TagValueHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;

abstract class AbstractTagValueHandler
implements TagValueHandler {
    private final String tag;
    private final OBOConsumer consumer;

    public AbstractTagValueHandler(String tag, OBOConsumer consumer) {
        this.tag = tag;
        this.consumer = consumer;
    }

    @Override
    public String getTagName() {
        return this.tag;
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.consumer.getOWLOntologyManager();
    }

    public OWLOntology getOntology() {
        return this.consumer.getOntology();
    }

    public void applyChange(OWLOntologyChange change) {
        this.consumer.getOWLOntologyManager().applyChange(change);
    }

    public OBOConsumer getConsumer() {
        return this.consumer;
    }

    public OWLDataFactory getDataFactory() {
        return this.consumer.getOWLOntologyManager().getOWLDataFactory();
    }

    public IRI getTagIRI(OBOVocabulary vocabulary) {
        return this.consumer.getIRIFromTagName(vocabulary.getName());
    }

    public IRI getTagIRI(String tagName) {
        return this.consumer.getIRIFromTagName(tagName);
    }

    public IRI getIRIFromOBOId(String id) {
        return this.consumer.getIRIFromOBOId(id);
    }

    public OWLAnnotation getAnnotationForTagValuePair(String tagName, String value) {
        IRI tagIRI = this.getTagIRI(tagName);
        OWLDataFactory df = this.getDataFactory();
        OWLAnnotationProperty annotationProperty = df.getOWLAnnotationProperty(tagIRI);
        String unescapedString = this.getUnquotedString(value);
        OWLLiteral annotationValue = df.getOWLLiteral(unescapedString);
        return df.getOWLAnnotation(annotationProperty, (OWLAnnotationValue)annotationValue);
    }

    public OWLClass getClassFromId(String s) {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(s));
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(this.consumer.getCurrentId()));
    }

    protected OWLClass getOWLClass(String id) {
        return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(id));
    }

    protected OWLObjectProperty getOWLObjectProperty(String id) {
        return this.getDataFactory().getOWLObjectProperty(this.getIRIFromOBOId(id));
    }

    protected String getUnquotedString(String value) {
        String unquotedString = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        return unquotedString;
    }

    protected OWLClassExpression getOWLClassOrRestriction(String termList) {
        String[] strings = termList.split(" ");
        if (strings.length == 1) {
            return this.getDataFactory().getOWLClass(this.getIRIFromOBOId(strings[0]));
        }
        String id0 = strings[0];
        String id1 = strings[1];
        IRI propertyIRI = this.getConsumer().getRelationIRIFromSymbolicIdOrOBOId(id0);
        OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(propertyIRI);
        OWLClass filler = this.getDataFactory().getOWLClass(this.getIRIFromOBOId(id1));
        return this.getDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, (OWLClassExpression)filler);
    }

    protected OWLLiteral getBooleanConstant(boolean b) {
        return this.getDataFactory().getOWLLiteral(b);
    }

    protected void addAnnotation(String id, String uriID, OWLLiteral value) {
        IRI subject = this.getIRIFromOBOId(id);
        OWLAnnotationProperty annotationProperty = this.getDataFactory().getOWLAnnotationProperty(this.getIRIFromOBOId(uriID));
        OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)subject, (OWLAnnotationValue)value);
        this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)ax));
    }
}

