/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.ProtocolException;
import com.sun.jini.jeri.internal.mux.Session;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.security.Security;
import net.jini.security.SecurityContext;

public class MuxServer
extends Mux {
    private static final int serverInitialInboundRation;
    private static final Executor userThreadPool;
    private static final Logger logger;
    private final RequestDispatcher requestDispatcher;
    private final SecurityContext securityContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MuxServer(OutputStream out, InputStream in, RequestDispatcher requestDispatcher) throws IOException {
        super(out, in, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    public MuxServer(SocketChannel channel, RequestDispatcher requestDispatcher) throws IOException {
        super(channel, 1, serverInitialInboundRation, 1024);
        this.requestDispatcher = requestDispatcher;
        this.securityContext = Security.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String message) {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.serverConnectionReady && this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
            }
            this.setDown(message, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownGracefully() {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.busySessions.isEmpty()) {
                this.asyncSendShutdown(null);
                this.setDown("mux connection shut down gracefully", null);
                return true;
            }
            return false;
        }
    }

    protected void checkPermissions() {
    }

    protected InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        if (constraints.requirements().isEmpty()) {
            return InvocationConstraints.EMPTY;
        }
        throw new UnsupportedConstraintException("cannot satisfy constraints: " + constraints);
    }

    protected void populateContext(Collection context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen(int sessionID) throws ProtocolException {
        Session session;
        if (!$assertionsDisabled && Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        Object object = this.muxLock;
        synchronized (object) {
            if (!this.busySessions.get(sessionID)) {
                this.dispatchNewRequest(sessionID);
                return;
            }
            session = (Session)this.sessions.get(new Integer(sessionID));
            if (!$assertionsDisabled && session == null) {
                throw new AssertionError();
            }
        }
        session.handleOpen();
        object = this.muxLock;
        synchronized (object) {
            this.dispatchNewRequest(sessionID);
        }
    }

    private void dispatchNewRequest(int sessionID) throws ProtocolException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.muxLock)) {
            throw new AssertionError();
        }
        if (this.muxDown) {
            throw new ProtocolException("connection down, cannot add new session");
        }
        final Session session = new Session(this, sessionID, 1);
        this.addSession(sessionID, session);
        try {
            userThreadPool.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InboundRequest request = session.getInboundRequest();
                    try {
                        AccessController.doPrivileged(MuxServer.this.securityContext.wrap(new PrivilegedAction(this, request){
                            private final /* synthetic */ InboundRequest val$request;
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$request = val$request;
                            }

                            public Object run() {
                                MuxServer.access$100(1.access$000(this.this$1)).dispatch(this.val$request);
                                return null;
                            }
                        }), MuxServer.this.securityContext.getAccessControlContext());
                    }
                    finally {
                        request.abort();
                    }
                }

                static /* synthetic */ MuxServer access$000(1 x0) {
                    return x0.MuxServer.this;
                }
            }, "mux request dispatch");
        }
        catch (OutOfMemoryError e) {
            try {
                logger.log(Level.WARNING, "could not create thread for request dispatch", e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            session.abort();
        }
    }

    static /* synthetic */ RequestDispatcher access$100(MuxServer x0) {
        return x0.requestDispatcher;
    }

    static {
        $assertionsDisabled = !MuxServer.class.desiredAssertionStatus();
        serverInitialInboundRation = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.connection.mux.server.initialInboundRation", 32768));
        userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(true));
        logger = Logger.getLogger("net.jini.jeri.connection.mux");
    }
}

