/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.constraint.InvocationConstraint;

public final class DiscoveryProtocolVersion
implements InvocationConstraint,
Serializable {
    private static final long serialVersionUID = 1781016120938012150L;
    public static final DiscoveryProtocolVersion ONE = new DiscoveryProtocolVersion(1);
    public static final DiscoveryProtocolVersion TWO = new DiscoveryProtocolVersion(2);
    private final int version;

    public static DiscoveryProtocolVersion getInstance(int version) {
        switch (version) {
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
        }
        return new DiscoveryProtocolVersion(version);
    }

    private DiscoveryProtocolVersion(int version) {
        if (version <= 0) {
            throw new IllegalArgumentException("invalid version");
        }
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return DiscoveryProtocolVersion.class.hashCode() + this.version;
    }

    public boolean equals(Object obj) {
        return obj instanceof DiscoveryProtocolVersion && this.version == ((DiscoveryProtocolVersion)obj).version;
    }

    public String toString() {
        return "DiscoveryProtocolVersion[" + this.version + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.version <= 0) {
            throw new InvalidObjectException("invalid version");
        }
    }
}

