/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.util.PropertyUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class TestCase2
extends TestCase {
    protected static final Logger log = Logger.getLogger(Test.class);
    private Random m_random = new Random();
    protected RandomType _randomType = new RandomType();

    public TestCase2() {
    }

    public TestCase2(String name) {
        super(name);
    }

    public static void fail(String message, Throwable t) {
        AssertionFailedError ex = new AssertionFailedError(message);
        ex.initCause(t);
        throw ex;
    }

    public static void assertEquals(boolean[] expected, boolean[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, boolean[] expected, boolean[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == actual) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        } else if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        } else if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (boolean)expected[i], (boolean)actual[i]);
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, byte[] expected, byte[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (byte)expected[i], (byte)actual[i]);
        }
    }

    public static void assertEquals(char[] expected, char[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, char[] expected, char[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (char)expected[i], (char)actual[i]);
        }
    }

    public static void assertEquals(short[] expected, short[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, short[] expected, short[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (short)expected[i], (short)actual[i]);
        }
    }

    public static void assertEquals(int[] expected, int[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, int[] expected, int[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (int)expected[i], (int)actual[i]);
        }
    }

    public static void assertEquals(long[] expected, long[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, long[] expected, long[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            TestCase2.assertEquals((String)(msg + "values differ: index=" + i), (long)expected[i], (long)actual[i]);
        }
    }

    public static void assertEquals(float[] expected, float[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, float[] expected, float[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            float delta = 0.0f;
            try {
                TestCase2.assertEquals((float)expected[i], (float)actual[i], (float)delta);
                continue;
            }
            catch (AssertionFailedError ex) {
                TestCase2.fail(msg + "values differ: index=" + i, ex);
            }
        }
    }

    public static void assertEquals(double[] expected, double[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, double[] expected, double[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            double delta = 0.0;
            try {
                TestCase2.assertEquals((double)expected[i], (double)actual[i], (double)delta);
                continue;
            }
            catch (AssertionFailedError ex) {
                TestCase2.fail(msg + "values differ: index=" + i, ex);
            }
        }
    }

    public static void assertEquals(Object[] expected, Object[] actual) {
        TestCase2.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String msg, Object[] expected, Object[] actual) {
        msg = msg == null ? "" : msg + " : ";
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(msg + "Expected a null array."));
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(msg + "Not expecting a null array."));
        }
        if (expected.length != actual.length) {
            TestCase2.assertEquals((String)(msg + "length differs."), (int)expected.length, (int)actual.length);
        }
        for (int i = 0; i < expected.length; ++i) {
            try {
                TestCase2.assertEquals((Object)expected[i], (Object)actual[i]);
                continue;
            }
            catch (AssertionFailedError ex) {
                TestCase2.fail(msg + "values differ: index=" + i, ex);
            }
        }
    }

    public static void assertSameValue(Object expected, Object actual) {
        TestCase2.assertSameValue(null, expected, actual);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void assertSameValue(String msg, Object expected, Object actual) {
        if (expected != null && expected.getClass().isArray()) {
            if (expected.getClass().getComponentType().isPrimitive()) {
                Class<?> componentType = expected.getClass().getComponentType();
                if (componentType.equals(Boolean.TYPE)) {
                    TestCase2.assertEquals(msg, (boolean[])expected, (boolean[])actual);
                    return;
                } else if (componentType.equals(Byte.TYPE)) {
                    TestCase2.assertEquals(msg, (byte[])expected, (byte[])actual);
                    return;
                } else if (componentType.equals(Character.TYPE)) {
                    TestCase2.assertEquals(msg, (char[])expected, (char[])actual);
                    return;
                } else if (componentType.equals(Short.TYPE)) {
                    TestCase2.assertEquals(msg, (short[])expected, (short[])actual);
                    return;
                } else if (componentType.equals(Integer.TYPE)) {
                    TestCase2.assertEquals(msg, (int[])expected, (int[])actual);
                    return;
                } else if (componentType.equals(Long.TYPE)) {
                    TestCase2.assertEquals(msg, (long[])expected, (long[])actual);
                    return;
                } else if (componentType.equals(Float.TYPE)) {
                    TestCase2.assertEquals(msg, (float[])expected, (float[])actual);
                    return;
                } else {
                    if (!componentType.equals(Double.TYPE)) throw new AssertionError();
                    TestCase2.assertEquals(msg, (double[])expected, (double[])actual);
                }
                return;
            } else {
                TestCase2.assertTrue((String)msg, (boolean)Arrays.equals((Object[])expected, (Object[])actual));
            }
            return;
        } else {
            TestCase2.assertEquals((String)msg, (Object)expected, (Object)actual);
        }
    }

    public static void assertSameIterator(Object[] expected, Iterator actual) {
        TestCase2.assertSameIterator("", expected, actual);
    }

    public static void assertSameIterator(String msg, Object[] expected, Iterator actual) {
        int i = 0;
        while (actual.hasNext()) {
            if (i >= expected.length) {
                TestCase2.fail((String)(msg + ": The iterator is willing to visit more than " + expected.length + " objects."));
            }
            Object g = actual.next();
            try {
                TestCase2.assertSameValue(expected[i], g);
            }
            catch (AssertionFailedError ex) {
                TestCase2.fail((String)(msg + ": Different objects at index=" + i + ": expected=" + expected[i] + ", actual=" + g));
            }
            ++i;
        }
        if (i < expected.length) {
            TestCase2.fail((String)(msg + ": The iterator SHOULD have visited " + expected.length + " objects, but only visited " + i + " objects."));
        }
    }

    public static void assertSameIteratorAnyOrder(Object[] expected, Iterator actual) {
        TestCase2.assertSameIteratorAnyOrder("", expected, actual);
    }

    public static void assertSameIteratorAnyOrder(String msg, Object[] expected, Iterator actual) {
        int j;
        int nrange = expected.length;
        HashMap<Object, Object> range = new HashMap<Object, Object>();
        for (j = 0; j < nrange; ++j) {
            range.put(expected[j], expected[j]);
        }
        for (j = 0; j < nrange; ++j) {
            Object actualObject;
            if (!actual.hasNext()) {
                TestCase2.fail((String)(msg + ": Index exhausted while expecting more object(s)" + ": index=" + j));
            }
            if (range.remove(actualObject = actual.next()) != null) continue;
            TestCase2.fail((String)("Object not expected: index=" + j + ", object=" + actualObject));
        }
        if (actual.hasNext()) {
            TestCase2.fail((String)"Iterator will deliver too many objects.");
        }
    }

    public static int[] getRandomOrder(int n) {
        final class Pair
        implements Comparable<Pair> {
            public final double r = Math.random();
            public final int val;

            public Pair(int val) {
                this.val = val;
            }

            @Override
            public int compareTo(Pair other) {
                if (this == other) {
                    return 0;
                }
                if (this.r < other.r) {
                    return -1;
                }
                return 1;
            }
        }
        Object[] pairs = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pairs[i] = new Pair(i);
        }
        Arrays.sort(pairs);
        int[] order = new int[n];
        for (int i = 0; i < n; ++i) {
            order[i] = ((Pair)pairs[i]).val;
        }
        return order;
    }

    public int getNormalInt(int range) {
        int r;
        double bound = 3.0;
        double rand = this.m_random.nextGaussian();
        if (rand < -3.0) {
            rand = -3.0;
        } else if (rand > 3.0) {
            rand = 3.0;
        }
        rand = (rand + 3.0) / 6.0;
        if (rand < 0.0) {
            rand = 0.0;
        }
        if ((r = (int)(rand * (double)range)) > range) {
            throw new AssertionError();
        }
        return r;
    }

    public String getRandomString(int len, int id) {
        String data = "0123456789QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm";
        int[] order = TestCase2.getRandomOrder("0123456789QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm".length());
        int n = this.getNormalInt(len);
        StringBuilder sb = new StringBuilder(n);
        int index = 0;
        for (int i = 0; i < n; ++i) {
            sb.append("0123456789QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm".charAt(order[index++]));
            if (index != order.length) continue;
            index = 0;
        }
        sb.append(id);
        return sb.toString();
    }

    public Object getRandomObject(boolean allowNull) {
        return this._randomType.nextObject(this.m_random, allowNull);
    }

    public Object getRandomObject(Random rnd, boolean allowNull) {
        return this._randomType.nextObject(rnd, allowNull);
    }

    public InputStream getTestInputStream(String resourceName) {
        TestCase2 context = this;
        log.info((Object)("Getting input stream for: " + resourceName));
        try {
            ClassLoader cl = ((Object)((Object)context)).getClass().getClassLoader();
            if (cl == null) {
                throw new AssertionError((Object)("Could not get ClassLoader: " + ((Object)((Object)context)).getClass()));
            }
            InputStream is = cl.getResourceAsStream(resourceName);
            if (is == null) {
                log.error((Object)("Could not locate resource: '" + resourceName + "'"));
                throw new AssertionError((Object)("Could not locate resource: '" + resourceName + "'"));
            }
            return is;
        }
        catch (Exception ex) {
            log.error((Object)("Could not read from " + resourceName), (Throwable)ex);
            throw new AssertionFailedError("Could not read from " + resourceName + " : " + ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTestResource(String resourceName, String encoding) {
        String string;
        log.info((Object)("Reading local test resource: " + resourceName));
        InputStream is = this.getTestInputStream(resourceName);
        InputStreamReader r = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
        try {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = ((Reader)r).read()) != -1) {
                sb.append((char)ch);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Read " + sb.length() + " characters from " + resourceName));
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)r).close();
                throw throwable;
            }
            catch (Exception ex) {
                log.error((Object)("Could not read from " + resourceName), (Throwable)ex);
                throw new AssertionFailedError("Could not read from " + resourceName + " : " + ex.toString());
            }
        }
        ((Reader)r).close();
        return string;
    }

    public String getTestResource(String resourceName) {
        return this.getTestResource(resourceName, null);
    }

    public Properties getProperties() {
        MyProperties m_properties = null;
        if (m_properties == null) {
            try {
                log.info((Object)"Will read properties.");
                m_properties = new MyProperties("<none>");
                String className = ((Object)((Object)this)).getClass().getName();
                String resourceName = className.replace('.', '/') + ".properties";
                log.info((Object)("Will try to read properties from resource: " + resourceName));
                ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                InputStream is = cl.getResourceAsStream(resourceName);
                if (is != null) {
                    MyProperties newLayer = new MyProperties(resourceName, m_properties);
                    newLayer.load(is);
                    m_properties = newLayer;
                } else {
                    log.debug((Object)("No properties resource named: " + resourceName));
                }
                String userHome = System.getProperty("user.home");
                if (userHome == null) {
                    log.error((Object)"The System property 'user.home' is not defined.");
                    throw new AssertionError((Object)"The System property 'user.home' is not defined.");
                }
                File file = new File(userHome + File.separator + "build.properties");
                if (log.isInfoEnabled()) {
                    log.info((Object)("Looking for properties file in home directory: " + file));
                }
                if (!file.exists()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Looking for properties file in home directory: " + file));
                    }
                } else {
                    if (!file.isFile()) {
                        log.error((Object)("Not a normal file: " + file));
                        throw new IOException("Not a normal file: " + file);
                    }
                    if (!file.canRead()) {
                        log.error((Object)("Can not read file: " + file));
                        throw new IOException("Can not read file: " + file);
                    }
                    m_properties = new MyProperties(file.toString(), m_properties);
                    m_properties.load(new FileInputStream(file));
                }
                m_properties = new MyProperties("System.getProperties()", m_properties);
                m_properties.putAll((Map<?, ?>)PropertyUtil.flatten(System.getProperties()));
                if (this.isDEBUG()) {
                    this.logProperties(m_properties, 0);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                RuntimeException ex2 = new RuntimeException("Could not load properties.");
                ex2.initCause(ex);
                throw ex2;
            }
        }
        return m_properties;
    }

    protected void logProperties(MyProperties properties, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("Properties:: [ source = '" + properties.getSource() + "' ]\n");
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(properties);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(this.indent(level) + "'" + name + "'" + " = " + (value != null ? "'" + value + "'" : "<none>") + "\n");
        }
        log.info((Object)sb.toString());
        MyProperties defaults = properties.getDefaults();
        if (defaults != null) {
            this.logProperties(defaults, level + 1);
        }
    }

    private String indent(int level) {
        String s = "...";
        if (level == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(level * "...".length());
        for (int i = 0; i < level; ++i) {
            sb.append("...");
        }
        return "...".toString();
    }

    public static String getProjectBuildPath() throws UnsupportedOperationException {
        String x = System.getProperty("maven.build.dir");
        if (x == null) {
            String msg = "The 'maven.build.dir' property is NOT defined.  Did you forget to defined 'maven.junit.sysproperties=maven.build.dir ...'";
            log.error((Object)"The 'maven.build.dir' property is NOT defined.  Did you forget to defined 'maven.junit.sysproperties=maven.build.dir ...'");
            throw new UnsupportedOperationException("The 'maven.build.dir' property is NOT defined.  Did you forget to defined 'maven.junit.sysproperties=maven.build.dir ...'");
        }
        log.info((Object)("maven.build.dir='" + x + "'"));
        return x;
    }

    public static final boolean isDEBUG(Logger log) {
        return log.getEffectiveLevel().toInt() <= Level.DEBUG.toInt();
    }

    public static final boolean isINFO(Logger log) {
        return log.getEffectiveLevel().toInt() <= Level.INFO.toInt();
    }

    public final boolean isDEBUG() {
        return TestCase2.isDEBUG(log);
    }

    public final boolean isINFO() {
        return TestCase2.isINFO(log);
    }

    protected static int getUlps(float A, float B) {
        int bInt;
        int aInt = Float.floatToIntBits(A);
        if (aInt < 0) {
            aInt = Integer.MIN_VALUE - aInt;
        }
        if ((bInt = Float.floatToIntBits(B)) < 0) {
            bInt = Integer.MIN_VALUE - bInt;
        }
        int intDiff = Math.abs(aInt - bInt);
        return intDiff;
    }

    protected static long getUlps(double A, double B) {
        long bLong;
        long aLong = Double.doubleToLongBits(A);
        if (aLong < 0L) {
            aLong = Long.MIN_VALUE - aLong;
        }
        if ((bLong = Double.doubleToLongBits(B)) < 0L) {
            bLong = Long.MIN_VALUE - bLong;
        }
        long longDiff = Math.abs(aLong - bLong);
        return longDiff;
    }

    protected void assertZeroUlps(float f1, float f2) {
        int ulps = TestCase2.getUlps(f1, f2);
        if (ulps != 0) {
            TestCase2.fail((String)("Expecting zero ulps, but found: " + ulps + "; f1=" + f1 + ", f2=" + f2));
        }
    }

    protected void assertZeroUlps(double d1, double d2) {
        long ulps = TestCase2.getUlps(d1, d2);
        if (ulps != 0L) {
            TestCase2.fail((String)("Expecting zero ulps, but found: " + ulps + "; f1=" + d1 + ", f2=" + d2));
        }
    }

    public static void assertEquals(float expected, float actual) {
        TestCase2.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, float expected, float actual) {
        if (expected == actual) {
            return;
        }
        int maxUlps = 10;
        int ulps = TestCase2.getUlps(expected, actual);
        if (ulps <= 10) {
            return;
        }
        TestCase2.fail((String)("Expecting " + expected + ", not " + actual + ": abs(difference)=" + Math.abs(expected - actual) + ": ulps=" + ulps));
    }

    public static void assertEquals(double expected, double actual) {
        TestCase2.assertEquals("", expected, actual);
    }

    public static void assertEquals(String message, double expected, double actual) {
        TestCase2.assertEqualsWithinUlps(message, expected, actual, 10L);
    }

    public static void assertEqualsWithinUlps(String message, double expected, double actual, long maxUlps) {
        if (expected == actual) {
            return;
        }
        long ulps = TestCase2.getUlps(expected, actual);
        if (ulps <= maxUlps) {
            return;
        }
        TestCase2.fail((String)("Expecting " + expected + ", not " + actual + ": abs(difference)=" + Math.abs(expected - actual) + ", ulps=" + ulps));
    }

    public static void assertSameBigInteger(BigInteger expected, BigInteger actual) {
        TestCase2.assertSameBigInteger("", expected, actual);
    }

    public static void assertSameBigInteger(String message, BigInteger expected, BigInteger actual) {
        TestCase2.assertTrue((String)(message + ": expected " + expected + ", not " + actual), (boolean)expected.equals(actual));
    }

    public static void assertSameBigDecimal(BigDecimal expected, BigDecimal actual) {
        TestCase2.assertEquals((String)"", (Object)expected, (Object)actual);
    }

    public static void assertSameBigDecimal(String message, BigDecimal expected, BigDecimal actual) {
        TestCase2.assertTrue((String)(message + ": expected " + expected + ", not " + actual), (expected.compareTo(actual) == 0 ? 1 : 0) != 0);
    }

    public static void assertSameArray(Object[] expected, Object[] actual) {
        TestCase2.assertSameArray("", expected, actual);
    }

    public static void assertSameArray(String message, Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && actual == null) {
            TestCase2.fail((String)(message + " : expecting actual to be non-null."));
        }
        if (expected == null && actual != null) {
            TestCase2.fail((String)(message + " : expecting actual to be null."));
        }
        TestCase2.assertEquals((String)(message + " : length is wrong."), (int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == null && actual[i] == null) continue;
            if (expected[i] != null && actual[i] == null) {
                TestCase2.fail((String)(message + " : expecting actual[" + i + "] to be non-null"));
            }
            if (expected[i] == null && actual[i] != null) {
                TestCase2.fail((String)(message + " : expecting actual[" + i + "] to be null."));
            }
            TestCase2.assertTrue((String)(message + " : expected[" + i + "]=" + expected[i] + ", but actual[" + i + "]=" + actual[i]), (boolean)expected[i].equals(actual[i]));
        }
    }

    public static Throwable getInnerCause(Throwable t, Class cls) {
        if (t == null) {
            throw new IllegalArgumentException();
        }
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        for (Class<?> x = t.getClass(); x != null; x = x.getSuperclass()) {
            if (x != cls) continue;
            return t;
        }
        if ((t = t.getCause()) == null) {
            return null;
        }
        return TestCase2.getInnerCause(t, cls);
    }

    public static boolean isInnerCause(Throwable t, Class cls) {
        return TestCase2.getInnerCause(t, cls) != null;
    }

    protected static class MyProperties
    extends Properties {
        private static final long serialVersionUID = 3980787538394715754L;
        String m_source = null;

        public String getSource() {
            return this.m_source;
        }

        public MyProperties getDefaults() {
            return (MyProperties)this.defaults;
        }

        public MyProperties(String source) {
            this.m_source = source;
        }

        public MyProperties(String source, MyProperties defaults) {
            super(defaults);
            this.m_source = source;
        }
    }

    protected class RandomType {
        public static final short BOOLEAN = 20;
        public static final short BYTE = 21;
        public static final short CHAR = 22;
        public static final short SHORT = 23;
        public static final short INT = 24;
        public static final short LONG = 25;
        public static final short FLOAT = 26;
        public static final short DOUBLE = 27;
        public static final short STRING = 28;
        public static final short OBJECT = 30;
        public static final short OBJECT_ARRAY = 31;
        public static final short BOOLEAN_ARRAY = 40;
        public static final short BYTE_ARRAY = 41;
        public static final short CHAR_ARRAY = 42;
        public static final short SHORT_ARRAY = 43;
        public static final short INT_ARRAY = 44;
        public static final short LONG_ARRAY = 45;
        public static final short FLOAT_ARRAY = 46;
        public static final short DOUBLE_ARRAY = 47;
        public final int[] randomType = new int[]{20, 21, 22, 23, 24, 25, 26, 27, 28, 30};
        private static final String alphabet = "0123456789QWERTYUIOPASDFGHJKLZXCVBNMqwertyuiopasdfghjklzxcvbnm";

        protected RandomType() {
        }

        public int getType(Class cls) {
            if (cls == null) {
                throw new IllegalArgumentException();
            }
            if (cls.equals(Boolean.class)) {
                return 20;
            }
            if (cls.equals(Byte.class)) {
                return 21;
            }
            if (cls.equals(Character.class)) {
                return 22;
            }
            if (cls.equals(Short.class)) {
                return 23;
            }
            if (cls.equals(Integer.class)) {
                return 24;
            }
            if (cls.equals(Long.class)) {
                return 25;
            }
            if (cls.equals(Float.class)) {
                return 26;
            }
            if (cls.equals(Double.class)) {
                return 27;
            }
            if (cls.equals(String.class)) {
                return 28;
            }
            if (cls.equals(Object.class)) {
                return 30;
            }
            throw new UnsupportedOperationException("class=" + cls);
        }

        public Object nextObject(Random rnd, boolean allowNull) {
            int[] types = this.randomType;
            int range = types.length;
            if (!allowNull) {
                --range;
            }
            int type = types[rnd.nextInt(range)];
            return this.nextObject(rnd, type, allowNull);
        }

        public Object nextObject(Random rnd, Class cls, boolean allowNull) {
            if (cls == null) {
                return this.nextObject(rnd, allowNull);
            }
            return this.nextObject(rnd, this.getType(cls), allowNull);
        }

        public Object nextObject(Random rnd, int type, boolean allowNull) {
            Object obj = null;
            switch (type) {
                case 20: {
                    obj = rnd.nextBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 21: {
                    obj = (byte)(rnd.nextInt(255) - 127);
                    break;
                }
                case 22: {
                    obj = Character.valueOf(alphabet.charAt(rnd.nextInt(alphabet.length())));
                    break;
                }
                case 23: {
                    obj = (short)rnd.nextInt();
                    break;
                }
                case 24: {
                    obj = rnd.nextInt();
                    break;
                }
                case 25: {
                    obj = rnd.nextLong();
                    break;
                }
                case 26: {
                    obj = Float.valueOf(rnd.nextFloat());
                    break;
                }
                case 27: {
                    obj = rnd.nextDouble();
                    break;
                }
                case 28: {
                    obj = TestCase2.this.getRandomString(40, rnd.nextInt());
                    break;
                }
                case 30: {
                    obj = TestCase2.this.getRandomString(40, rnd.nextInt());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown type=" + type));
                }
            }
            return obj;
        }
    }
}

