/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia.xdr;

public class XDRInputBuffer {
    private final byte[] buf;
    private int off;
    private final int limit;

    public XDRInputBuffer(byte[] buffer, int off, int len) {
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off + len > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.buf = buffer;
        this.off = off;
        this.limit = off + len;
    }

    public long readLong() {
        long v = 0L;
        v += (0xFFL & (long)this.buf[this.off++]) << 56;
        v += (0xFFL & (long)this.buf[this.off++]) << 48;
        v += (0xFFL & (long)this.buf[this.off++]) << 40;
        v += (0xFFL & (long)this.buf[this.off++]) << 32;
        v += (0xFFL & (long)this.buf[this.off++]) << 24;
        v += (0xFFL & (long)this.buf[this.off++]) << 16;
        v += (0xFFL & (long)this.buf[this.off++]) << 8;
        return v += (0xFFL & (long)this.buf[this.off++]) << 0;
    }

    public int readInt() {
        int v = 0;
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 24));
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 16));
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 8));
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 0));
        return v;
    }

    public long readUInt() {
        long v = 0L;
        v += (0xFFL & (long)this.buf[this.off++]) << 24;
        v += (0xFFL & (long)this.buf[this.off++]) << 16;
        v += (0xFFL & (long)this.buf[this.off++]) << 8;
        return v += (0xFFL & (long)this.buf[this.off++]) << 0;
    }

    public short readShort() {
        int v = 0;
        this.off += 2;
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 8));
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 0));
        return (short)v;
    }

    public int readUShort() {
        int v = 0;
        this.off += 2;
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 8));
        v = (int)((long)v + ((0xFFL & (long)this.buf[this.off++]) << 0));
        return v;
    }

    public float readFloat() {
        int v = this.readInt();
        return Float.intBitsToFloat(v);
    }

    public double readDouble() {
        long v = this.readLong();
        return Double.longBitsToDouble(v);
    }

    public String readString() {
        int n = this.readInt();
        String s = new String(this.buf, this.off, n);
        this.off += n;
        this.pad();
        return s;
    }

    private void pad() {
        int newOffset = (this.off + 3) / 4 * 4;
        while (this.off < newOffset) {
            ++this.off;
        }
    }
}

