/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.GangliaMetadataMessage;
import com.bigdata.ganglia.GangliaMetricMessage;
import com.bigdata.ganglia.GangliaRequestMessage;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaMessage;
import com.bigdata.ganglia.IGangliaMessageDecoder;
import com.bigdata.ganglia.xdr.XDRInputBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class GangliaMessageDecoder31
implements IGangliaMessageDecoder {
    private static final Logger log = Logger.getLogger(GangliaMessageDecoder31.class);

    @Override
    public IGangliaMessage decode(byte[] data, int off, int len) {
        GangliaMessageTypeEnum recordType;
        XDRInputBuffer xdr = new XDRInputBuffer(data, off, len);
        try {
            recordType = GangliaMessageTypeEnum.valueOf(xdr.readInt());
        }
        catch (IllegalArgumentException ex) {
            log.warn((Object)("Unknown record type: " + ex));
            return null;
        }
        if (recordType.value() < GangliaMessageTypeEnum.METADATA.value()) {
            log.warn((Object)("Ganglia 2.5 record type: " + (Object)((Object)recordType)));
            return null;
        }
        String hostName = xdr.readString();
        String metricName = xdr.readString();
        boolean spoof = xdr.readInt() != 0;
        switch (recordType) {
            case METADATA: {
                Map<String, String[]> extraValues;
                String metricTypeStr = xdr.readString();
                String metricName2 = xdr.readString();
                String units = xdr.readString();
                GangliaSlopeEnum slope = GangliaSlopeEnum.valueOf(xdr.readInt());
                int tmax = xdr.readInt();
                int dmax = xdr.readInt();
                int nextra = xdr.readInt();
                if (nextra == 0) {
                    extraValues = Collections.emptyMap();
                } else {
                    extraValues = new LinkedHashMap();
                    for (int i = 0; i < nextra; ++i) {
                        String name = xdr.readString();
                        String value = xdr.readString();
                        String[] a = (String[])extraValues.get(name);
                        if (a == null) {
                            extraValues.put(name, new String[]{value});
                            continue;
                        }
                        String[] b = new String[a.length + 1];
                        System.arraycopy(a, 0, b, 0, a.length);
                        b[a.length] = value;
                        extraValues.put(name, b);
                    }
                }
                GangliaMessageTypeEnum metricType = GangliaMessageTypeEnum.fromGType(metricTypeStr);
                GangliaMetadataMessage msg = new GangliaMetadataMessage(hostName, metricName, spoof, metricType, metricName2, units, slope, tmax, dmax, extraValues);
                return msg;
            }
            case REQUEST: {
                GangliaRequestMessage msg = new GangliaRequestMessage(hostName, metricName, spoof);
                return msg;
            }
            case DOUBLE: 
            case FLOAT: 
            case INT32: 
            case INT16: 
            case UINT32: 
            case UINT16: 
            case STRING: {
                Object value;
                String format = xdr.readString();
                switch (recordType) {
                    case DOUBLE: {
                        value = xdr.readDouble();
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(xdr.readFloat());
                        break;
                    }
                    case INT32: {
                        value = xdr.readInt();
                        break;
                    }
                    case INT16: {
                        value = xdr.readShort();
                        break;
                    }
                    case UINT32: {
                        value = xdr.readUInt();
                        break;
                    }
                    case UINT16: {
                        value = xdr.readUShort();
                        break;
                    }
                    case STRING: {
                        value = xdr.readString();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                GangliaMetricMessage msg = new GangliaMetricMessage(recordType, hostName, metricName, spoof, format, value);
                return msg;
            }
        }
        log.warn((Object)("Not handled: " + (Object)((Object)recordType)));
        return null;
    }
}

