/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.AbstractMetrics;
import com.bigdata.ganglia.GangliaMessageTypeEnum;
import com.bigdata.ganglia.GangliaMetadataMessage;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.GangliaState;
import com.bigdata.ganglia.IGangliaMetadataMessage;

public class GangliaCoreMetricDecls
extends AbstractMetrics {
    protected final int heartbeatInterval;

    public GangliaCoreMetricDecls(String hostName, GangliaSlopeEnum slope, int tmax, int dmax, int heartbeatInterval) {
        super(hostName, slope, tmax, dmax);
        if (heartbeatInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.heartbeatInterval = heartbeatInterval;
    }

    public static final IGangliaMetadataMessage heartbeat(String hostName, int heartbeatInterval) {
        return new GangliaMetadataMessage(hostName, "heartbeat", false, GangliaMessageTypeEnum.UINT32, "heartbeat", "", GangliaSlopeEnum.unspecified, heartbeatInterval, 0, GangliaCoreMetricDecls.getMap("core", "heartbeat", "Last heartbeat"));
    }

    public final IGangliaMetadataMessage heartbeat() {
        return GangliaCoreMetricDecls.heartbeat(this.hostName, this.heartbeatInterval);
    }

    public final IGangliaMetadataMessage gexec() {
        return new GangliaMetadataMessage(this.hostName, "gexec", false, GangliaMessageTypeEnum.STRING, "gexec", "", GangliaSlopeEnum.zero, 300, 0, GangliaCoreMetricDecls.getMap("core", "Gexec Status", "gexec available"));
    }

    public final IGangliaMetadataMessage mem_free() {
        return new GangliaMetadataMessage(this.hostName, "mem_free", false, GangliaMessageTypeEnum.FLOAT, "mem_free", "KB", this.slope, this.tmax, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Free Memory", "Amount of available memory"));
    }

    public final IGangliaMetadataMessage mem_shared() {
        return new GangliaMetadataMessage(this.hostName, "mem_shared", false, GangliaMessageTypeEnum.FLOAT, "mem_shared", "KB", this.slope, this.tmax, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Shared Memory", "Amount of shared memory"));
    }

    public final IGangliaMetadataMessage mem_buffers() {
        return new GangliaMetadataMessage(this.hostName, "mem_buffers", false, GangliaMessageTypeEnum.FLOAT, "mem_buffers", "KB", this.slope, this.tmax, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Memory Buffers", "Amount of buffered memory"));
    }

    public final IGangliaMetadataMessage mem_cached() {
        return new GangliaMetadataMessage(this.hostName, "mem_cached", false, GangliaMessageTypeEnum.FLOAT, "mem_cached", "KB", this.slope, this.tmax, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Cached Memory", "Amount of cached memory"));
    }

    public final IGangliaMetadataMessage mem_total() {
        return new GangliaMetadataMessage(this.hostName, "mem_total", false, GangliaMessageTypeEnum.FLOAT, "mem_total", "KB", GangliaSlopeEnum.zero, 1200, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Memory Total", "Total amount of memory"));
    }

    public final IGangliaMetadataMessage swap_free() {
        return new GangliaMetadataMessage(this.hostName, "swap_free", false, GangliaMessageTypeEnum.FLOAT, "swap_free", "KB", this.slope, this.tmax, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Free Swap Space", "Amount of available swap memory"));
    }

    public final IGangliaMetadataMessage swap_total() {
        return new GangliaMetadataMessage(this.hostName, "swap_total", false, GangliaMessageTypeEnum.FLOAT, "swap_total", "KB", GangliaSlopeEnum.zero, 1200, this.dmax, GangliaCoreMetricDecls.getMap("memory", "Swap Space Total", "Total amount of swap space"));
    }

    public final IGangliaMetadataMessage load_one() {
        return new GangliaMetadataMessage(this.hostName, "load_one", false, GangliaMessageTypeEnum.FLOAT, "load_one", "", GangliaSlopeEnum.both, 70, 0, GangliaCoreMetricDecls.getMap("load", "One Minute Load Average", "One minute load average"));
    }

    public final IGangliaMetadataMessage load_five() {
        return new GangliaMetadataMessage(this.hostName, "load_five", false, GangliaMessageTypeEnum.FLOAT, "load_five", "", GangliaSlopeEnum.both, 325, 0, GangliaCoreMetricDecls.getMap("load", "Five Minute Load Average", "Five minute load average"));
    }

    public final IGangliaMetadataMessage load_fifteen() {
        return new GangliaMetadataMessage(this.hostName, "load_fifteen", false, GangliaMessageTypeEnum.FLOAT, "load_fifteen", "", GangliaSlopeEnum.both, 950, 0, GangliaCoreMetricDecls.getMap("load", "Fifteen Minute Load Average", "Fifteen minute load average"));
    }

    public final IGangliaMetadataMessage proc_run() {
        return new GangliaMetadataMessage(this.hostName, "proc_run", false, GangliaMessageTypeEnum.UINT32, "proc_run", "", GangliaSlopeEnum.both, 950, 0, GangliaCoreMetricDecls.getMap("process", "Total Running Processes", "Total number of running processes"));
    }

    public final IGangliaMetadataMessage proc_total() {
        return new GangliaMetadataMessage(this.hostName, "proc_total", false, GangliaMessageTypeEnum.UINT32, "proc_total", "", GangliaSlopeEnum.both, 950, 0, GangliaCoreMetricDecls.getMap("process", "Total Processes", "Total number of processes"));
    }

    public final IGangliaMetadataMessage cpu_user() {
        return new GangliaMetadataMessage(this.hostName, "cpu_user", false, GangliaMessageTypeEnum.FLOAT, "cpu_user", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU User", "Percentage of CPU utilization that occurred while executing at the user level"));
    }

    public final IGangliaMetadataMessage cpu_system() {
        return new GangliaMetadataMessage(this.hostName, "cpu_system", false, GangliaMessageTypeEnum.FLOAT, "cpu_system", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU System", "Percentage of CPU utilization that occurred while executing at the system level"));
    }

    public final IGangliaMetadataMessage cpu_idle() {
        return new GangliaMetadataMessage(this.hostName, "cpu_idle", false, GangliaMessageTypeEnum.FLOAT, "cpu_idle", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU Idle", "Percentage of time that the CPU or CPUs were idle and the system did not have an outstanding disk I/O request"));
    }

    public final IGangliaMetadataMessage cpu_nice() {
        return new GangliaMetadataMessage(this.hostName, "cpu_nice", false, GangliaMessageTypeEnum.FLOAT, "cpu_nice", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU Nice", "Percentage of CPU utilization that occurred while executing at the user level with nice priority"));
    }

    public final IGangliaMetadataMessage cpu_aidle() {
        return new GangliaMetadataMessage(this.hostName, "cpu_aidle", false, GangliaMessageTypeEnum.FLOAT, "cpu_aidle", "%", GangliaSlopeEnum.both, 3800, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU aidle", "Percent of time since boot idle CPU"));
    }

    public final IGangliaMetadataMessage cpu_wio() {
        return new GangliaMetadataMessage(this.hostName, "cpu_wio", false, GangliaMessageTypeEnum.FLOAT, "cpu_wio", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", "CPU wio", "Percentage of time that the CPU or CPUs were idle during which the system had an outstanding disk I/O request"));
    }

    public final IGangliaMetadataMessage cpu_intr() {
        return new GangliaMetadataMessage(this.hostName, "cpu_intr", false, GangliaMessageTypeEnum.FLOAT, "cpu_intr", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", null, null));
    }

    public final IGangliaMetadataMessage cpu_sintr() {
        return new GangliaMetadataMessage(this.hostName, "cpu_sintr", false, GangliaMessageTypeEnum.FLOAT, "cpu_sintr", "%", GangliaSlopeEnum.both, 90, this.dmax, GangliaCoreMetricDecls.getMap("cpu", null, null));
    }

    public final IGangliaMetadataMessage bytes_out() {
        return new GangliaMetadataMessage(this.hostName, "bytes_out", false, GangliaMessageTypeEnum.FLOAT, "bytes_out", "bytes/sec", GangliaSlopeEnum.both, 300, 0, GangliaCoreMetricDecls.getMap("network", "Bytes Sent", "Number of bytes out per second"));
    }

    public final IGangliaMetadataMessage bytes_in() {
        return new GangliaMetadataMessage(this.hostName, "bytes_in", false, GangliaMessageTypeEnum.FLOAT, "bytes_in", "bytes/sec", GangliaSlopeEnum.both, 300, 0, GangliaCoreMetricDecls.getMap("network", "Bytes Received", "Number of bytes in per second"));
    }

    public final IGangliaMetadataMessage pkts_in() {
        return new GangliaMetadataMessage(this.hostName, "pkts_in", false, GangliaMessageTypeEnum.FLOAT, "pkts_in", "packets/sec", GangliaSlopeEnum.both, 300, 0, GangliaCoreMetricDecls.getMap("network", "Packets Received", "Packets in per second"));
    }

    public final IGangliaMetadataMessage pkts_out() {
        return new GangliaMetadataMessage(this.hostName, "pkts_out", false, GangliaMessageTypeEnum.FLOAT, "pkts_out", "packets/sec", GangliaSlopeEnum.both, 300, 0, GangliaCoreMetricDecls.getMap("network", "Packets Sent", "Packets out per second"));
    }

    public final IGangliaMetadataMessage disk_total() {
        return new GangliaMetadataMessage(this.hostName, "disk_total", false, GangliaMessageTypeEnum.DOUBLE, "disk_total", "GB", GangliaSlopeEnum.both, 1200, 0, GangliaCoreMetricDecls.getMap("disk", "Total Disk Space", "Total available disk space"));
    }

    public final IGangliaMetadataMessage disk_free() {
        return new GangliaMetadataMessage(this.hostName, "disk_total", false, GangliaMessageTypeEnum.DOUBLE, "disk_total", "GB", GangliaSlopeEnum.both, this.tmax, 0, GangliaCoreMetricDecls.getMap("disk", "Disk Space Available", "Total free disk space"));
    }

    public final IGangliaMetadataMessage part_max_used() {
        return new GangliaMetadataMessage(this.hostName, "part_max_used", false, GangliaMessageTypeEnum.FLOAT, "part_max_used", "%", GangliaSlopeEnum.both, this.tmax, 0, GangliaCoreMetricDecls.getMap("disk", "Maximum Disk Space Used", "Maximum percent used for all partitions"));
    }

    public final IGangliaMetadataMessage boottime() {
        return new GangliaMetadataMessage(this.hostName, "boottime", false, GangliaMessageTypeEnum.UINT32, "boottime", "s", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("system", "Last Boot Time", "The last time that the system was started"));
    }

    public final IGangliaMetadataMessage machine_type() {
        return new GangliaMetadataMessage(this.hostName, "machine_type", false, GangliaMessageTypeEnum.STRING, "machine_type", "", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("system", "Machine Type", "System architecture"));
    }

    public final IGangliaMetadataMessage os_name() {
        return new GangliaMetadataMessage(this.hostName, "os_name", false, GangliaMessageTypeEnum.STRING, "os_name", "", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("system", "Operating System", "Operating system name"));
    }

    public final IGangliaMetadataMessage os_release() {
        return new GangliaMetadataMessage(this.hostName, "os_release", false, GangliaMessageTypeEnum.STRING, "os_release", "", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("system", "Operating System Release", "Operating system release"));
    }

    public final IGangliaMetadataMessage cpu_num() {
        return new GangliaMetadataMessage(this.hostName, "cpu_num", false, GangliaMessageTypeEnum.UINT16, "cpu_num", "CPUs", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("cpu", "CPU Count", "Total number of CPUs"));
    }

    public final IGangliaMetadataMessage cpu_speed() {
        return new GangliaMetadataMessage(this.hostName, "cpu_speed", false, GangliaMessageTypeEnum.UINT32, "cpu_speed", "MHz", GangliaSlopeEnum.zero, 1200, 0, GangliaCoreMetricDecls.getMap("cpu", "CPU Speed", "CPU Speed in terms of MHz"));
    }

    public final IGangliaMetadataMessage location() {
        return new GangliaMetadataMessage(this.hostName, "location", false, GangliaMessageTypeEnum.STRING, "location", "(x,y,z)", GangliaSlopeEnum.unspecified, 1200, 0, GangliaCoreMetricDecls.getMap(null, null, "Location of the machine"));
    }

    public void declare(GangliaState gangliaState) {
        gangliaState.putIfAbsent(this.heartbeat());
        gangliaState.putIfAbsent(this.gexec());
        gangliaState.putIfAbsent(this.mem_free());
        gangliaState.putIfAbsent(this.mem_shared());
        gangliaState.putIfAbsent(this.mem_buffers());
        gangliaState.putIfAbsent(this.mem_cached());
        gangliaState.putIfAbsent(this.mem_total());
        gangliaState.putIfAbsent(this.swap_free());
        gangliaState.putIfAbsent(this.swap_total());
        gangliaState.putIfAbsent(this.load_one());
        gangliaState.putIfAbsent(this.load_five());
        gangliaState.putIfAbsent(this.load_fifteen());
        gangliaState.putIfAbsent(this.proc_run());
        gangliaState.putIfAbsent(this.proc_total());
        gangliaState.putIfAbsent(this.cpu_user());
        gangliaState.putIfAbsent(this.cpu_system());
        gangliaState.putIfAbsent(this.cpu_idle());
        gangliaState.putIfAbsent(this.cpu_nice());
        gangliaState.putIfAbsent(this.cpu_aidle());
        gangliaState.putIfAbsent(this.cpu_wio());
        gangliaState.putIfAbsent(this.cpu_intr());
        gangliaState.putIfAbsent(this.cpu_sintr());
        gangliaState.putIfAbsent(this.bytes_in());
        gangliaState.putIfAbsent(this.bytes_out());
        gangliaState.putIfAbsent(this.pkts_in());
        gangliaState.putIfAbsent(this.pkts_out());
        gangliaState.putIfAbsent(this.disk_total());
        gangliaState.putIfAbsent(this.disk_free());
        gangliaState.putIfAbsent(this.part_max_used());
        gangliaState.putIfAbsent(this.boottime());
        gangliaState.putIfAbsent(this.machine_type());
        gangliaState.putIfAbsent(this.os_name());
        gangliaState.putIfAbsent(this.os_release());
        gangliaState.putIfAbsent(this.cpu_num());
        gangliaState.putIfAbsent(this.cpu_speed());
        gangliaState.putIfAbsent(this.location());
    }
}

