/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.EmptyNUnion;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.optimizer.FedXOptimizer;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class UnionOptimizer
extends AbstractQueryModelVisitor<OptimizationException>
implements FedXOptimizer {
    protected final QueryInfo queryInfo;

    public UnionOptimizer(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    @Override
    public void optimize(TupleExpr tupleExpr) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    public void meet(Union union) {
        ArrayList<TupleExpr> args = new ArrayList<TupleExpr>();
        this.handleUnionArgs(union, args);
        ArrayList<TupleExpr> filtered = new ArrayList<TupleExpr>(args.size());
        for (TupleExpr arg : args) {
            if (arg instanceof EmptyResult) continue;
            filtered.add(arg);
        }
        if (filtered.isEmpty()) {
            union.replaceWith((QueryModelNode)new EmptyNUnion(args, this.queryInfo));
        } else if (filtered.size() == 1) {
            union.replaceWith((QueryModelNode)filtered.get(0));
        } else {
            union.replaceWith((QueryModelNode)new NUnion(filtered, this.queryInfo));
        }
    }

    protected void handleUnionArgs(Union union, List<TupleExpr> args) {
        if (union.getLeftArg() instanceof Union) {
            this.handleUnionArgs((Union)union.getLeftArg(), args);
        } else {
            args.add(union.getLeftArg());
        }
        if (union.getRightArg() instanceof Union) {
            this.handleUnionArgs((Union)union.getRightArg(), args);
        } else {
            args.add(union.getRightArg());
        }
    }
}

