/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.RDFReaderI;
import org.apache.jena.rdf.model.impl.NTripleReader;
import org.apache.jena.rdfxml.xmlinput.JenaReader;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoReaderForLangException;
import org.apache.jena.ttl.turtle.TurtleReader;

public class RDFReaderFImpl
implements RDFReaderF {
    public static final String DEFAULTLANG = "RDF/XML";
    private static Map<String, Class<? extends RDFReaderI>> custom = new LinkedHashMap<String, Class<? extends RDFReaderI>>();
    private static RDFReaderF rewiredAlternative = null;

    public static void alternative(RDFReaderF other) {
        rewiredAlternative = other;
    }

    @Override
    public RDFReaderI getReader() {
        return this.getReader(null);
    }

    @Override
    public RDFReaderI getReader(String lang) {
        if (lang == null || lang.equals("")) {
            lang = DEFAULTLANG;
        }
        if (rewiredAlternative != null) {
            return rewiredAlternative.getReader(lang);
        }
        Class<? extends RDFReaderI> c = custom.get(lang);
        if (c == null) {
            throw new NoReaderForLangException("Reader not found: " + lang);
        }
        try {
            return c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    private static void reset() {
        Class<JenaReader> rdfxmlReader = JenaReader.class;
        Class<NTripleReader> ntReader = NTripleReader.class;
        Class<TurtleReader> turtleReader = TurtleReader.class;
        custom.put("RDF", rdfxmlReader);
        custom.put(DEFAULTLANG, rdfxmlReader);
        custom.put("RDF/XML-ABBREV", rdfxmlReader);
        custom.put("N-TRIPLE", ntReader);
        custom.put("N-TRIPLES", ntReader);
        custom.put("N-Triples", ntReader);
        custom.put("N3", turtleReader);
        custom.put("TURTLE", turtleReader);
        custom.put("Turtle", turtleReader);
        custom.put("TTL", turtleReader);
    }

    private static String currentEntry(String lang) {
        Class<? extends RDFReaderI> oldClass = custom.get(lang);
        if (oldClass != null) {
            return oldClass.getName();
        }
        return null;
    }

    private static String remove(String lang) {
        if (rewiredAlternative != null) {
            Log.error(RDFReaderFImpl.class, (String)"Rewired RDFReaderFImpl - configuration changes have no effect on reading");
        }
        String oldClassName = RDFReaderFImpl.currentEntry(lang);
        custom.remove(lang);
        return oldClassName;
    }

    static {
        RDFReaderFImpl.reset();
    }
}

