/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class Factory {
    private static final Graph emptyGraph = new GraphBase(){

        @Override
        protected ExtendedIterator<Triple> graphBaseFind(Triple triplePattern) {
            return NullIterator.instance();
        }
    };

    private Factory() {
    }

    public static Graph createDefaultGraph() {
        return Factory.createGraphMem();
    }

    public static Graph createGraphMem() {
        return new GraphMem();
    }

    @Deprecated
    public static Graph createGraphMemWithTransactionHandler(final TransactionHandler th) {
        GraphMem g = new GraphMem(){

            @Override
            public TransactionHandler getTransactionHandler() {
                return th;
            }
        };
        return g;
    }

    public static Graph empty() {
        return emptyGraph;
    }
}

