/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectMap;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortHash;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Short2ObjectOpenCustomHashMap<V>
extends AbstractShort2ObjectMap<V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient short[] key;
    protected transient V[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Short2ObjectMap.FastEntrySet<V> entries;
    protected volatile transient ShortSet keys;
    protected volatile transient ObjectCollection<V> values;
    protected ShortHash.Strategy strategy;

    public Short2ObjectOpenCustomHashMap(int expected, float f, ShortHash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new short[this.n];
        this.value = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public Short2ObjectOpenCustomHashMap(int expected, ShortHash.Strategy strategy) {
        this(expected, 0.75f, strategy);
    }

    public Short2ObjectOpenCustomHashMap(ShortHash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Short2ObjectOpenCustomHashMap(Map<? extends Short, ? extends V> m, float f, ShortHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Short2ObjectOpenCustomHashMap(Map<? extends Short, ? extends V> m, ShortHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Short2ObjectOpenCustomHashMap(Short2ObjectMap<V> m, float f, ShortHash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Short2ObjectOpenCustomHashMap(Short2ObjectMap<V> m, ShortHash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Short2ObjectOpenCustomHashMap(short[] k, V[] v, float f, ShortHash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Short2ObjectOpenCustomHashMap(short[] k, V[] v, ShortHash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public ShortHash.Strategy strategy() {
        return this.strategy;
    }

    @Override
    public V put(short k, V v) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Short ok, V ov) {
        V v = ov;
        short k = ok;
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.strategy.hashCode(this.key[pos]) ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.value[last] = null;
        return last;
    }

    @Override
    public V remove(short k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object ok) {
        short k = (Short)ok;
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    public V get(Short ok) {
        short k = ok;
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V get(short k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsKey(short k) {
        int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.strategy.equals(this.key[pos], k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || !(value[i] == null ? v == null : value[i].equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.used, false);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Short2ObjectMap.FastEntrySet<V> short2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ShortSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Short2ObjectOpenCustomHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Short2ObjectOpenCustomHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Short2ObjectOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        short[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        short[] newKey = new short[newN];
        Object[] newValue = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            short k = key[i];
            int pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Short2ObjectOpenCustomHashMap<V> clone() {
        Short2ObjectOpenCustomHashMap c;
        try {
            c = (Short2ObjectOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (short[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.strategy = this.strategy;
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.strategy.hashCode(this.key[i]);
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : this.value[i].hashCode();
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        short[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeShort(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new short[this.n];
        short[] key = this.key;
        this.value = new Object[this.n];
        Object[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            short k = s.readShort();
            Object v = s.readObject();
            pos = HashCommon.murmurHash3(this.strategy.hashCode(k) ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Short2ObjectOpenCustomHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractShortSet {
        private KeySet() {
        }

        @Override
        public ShortIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Short2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public boolean contains(short k) {
            return Short2ObjectOpenCustomHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(short k) {
            int oldSize = Short2ObjectOpenCustomHashMap.this.size;
            Short2ObjectOpenCustomHashMap.this.remove(k);
            return Short2ObjectOpenCustomHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Short2ObjectOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ShortIterator {
        @Override
        public short nextShort() {
            return Short2ObjectOpenCustomHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Short next() {
            return Short2ObjectOpenCustomHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Short2ObjectMap.Entry<V>>
    implements Short2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Short2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Short2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(Short2ObjectOpenCustomHashMap.this.strategy.hashCode(k) ^ Short2ObjectOpenCustomHashMap.this.mask) & Short2ObjectOpenCustomHashMap.this.mask;
            while (Short2ObjectOpenCustomHashMap.this.used[pos]) {
                if (Short2ObjectOpenCustomHashMap.this.strategy.equals(Short2ObjectOpenCustomHashMap.this.key[pos], k)) {
                    return Short2ObjectOpenCustomHashMap.this.value[pos] == null ? e.getValue() == null : Short2ObjectOpenCustomHashMap.this.value[pos].equals(e.getValue());
                }
                pos = pos + 1 & Short2ObjectOpenCustomHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(Short2ObjectOpenCustomHashMap.this.strategy.hashCode(k) ^ Short2ObjectOpenCustomHashMap.this.mask) & Short2ObjectOpenCustomHashMap.this.mask;
            while (Short2ObjectOpenCustomHashMap.this.used[pos]) {
                if (Short2ObjectOpenCustomHashMap.this.strategy.equals(Short2ObjectOpenCustomHashMap.this.key[pos], k)) {
                    Short2ObjectOpenCustomHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Short2ObjectOpenCustomHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Short2ObjectOpenCustomHashMap.this.size;
        }

        @Override
        public void clear() {
            Short2ObjectOpenCustomHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Short2ObjectMap.Entry<V>> {
        final AbstractShort2ObjectMap.BasicEntry<V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractShort2ObjectMap.BasicEntry<Object>(0, null);
        }

        @Override
        public AbstractShort2ObjectMap.BasicEntry<V> next() {
            int e = this.nextEntry();
            this.entry.key = Short2ObjectOpenCustomHashMap.this.key[e];
            this.entry.value = Short2ObjectOpenCustomHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Short2ObjectMap.Entry<V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Short2ObjectMap.Entry<V> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        ShortArrayList wrapped;

        private MapIterator() {
            this.pos = Short2ObjectOpenCustomHashMap.this.n;
            this.last = -1;
            this.c = Short2ObjectOpenCustomHashMap.this.size;
            boolean[] used = Short2ObjectOpenCustomHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                short k = this.wrapped.getShort(-this.pos - 2);
                int pos = HashCommon.murmurHash3(Short2ObjectOpenCustomHashMap.this.strategy.hashCode(k) ^ Short2ObjectOpenCustomHashMap.this.mask) & Short2ObjectOpenCustomHashMap.this.mask;
                while (Short2ObjectOpenCustomHashMap.this.used[pos]) {
                    if (Short2ObjectOpenCustomHashMap.this.strategy.equals(Short2ObjectOpenCustomHashMap.this.key[pos], k)) {
                        return pos;
                    }
                    pos = pos + 1 & Short2ObjectOpenCustomHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Short2ObjectOpenCustomHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Short2ObjectOpenCustomHashMap.this.mask;
                while (Short2ObjectOpenCustomHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Short2ObjectOpenCustomHashMap.this.strategy.hashCode(Short2ObjectOpenCustomHashMap.this.key[pos]) ^ Short2ObjectOpenCustomHashMap.this.mask) & Short2ObjectOpenCustomHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Short2ObjectOpenCustomHashMap.this.mask;
                }
                if (!Short2ObjectOpenCustomHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ShortArrayList();
                    }
                    this.wrapped.add(Short2ObjectOpenCustomHashMap.this.key[pos]);
                }
                Short2ObjectOpenCustomHashMap.this.key[last] = Short2ObjectOpenCustomHashMap.this.key[pos];
                Short2ObjectOpenCustomHashMap.this.value[last] = Short2ObjectOpenCustomHashMap.this.value[pos];
            }
            Short2ObjectOpenCustomHashMap.this.used[last] = false;
            Short2ObjectOpenCustomHashMap.this.value[last] = null;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Short2ObjectOpenCustomHashMap.this.remove(this.wrapped.getShort(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Short2ObjectOpenCustomHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Short2ObjectMap.Entry<V>,
    Map.Entry<Short, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Short getKey() {
            return Short2ObjectOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public short getShortKey() {
            return Short2ObjectOpenCustomHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Short2ObjectOpenCustomHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Short2ObjectOpenCustomHashMap.this.value[this.index];
            Short2ObjectOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Short2ObjectOpenCustomHashMap.this.strategy.equals(Short2ObjectOpenCustomHashMap.this.key[this.index], (Short)e.getKey()) && (Short2ObjectOpenCustomHashMap.this.value[this.index] == null ? e.getValue() == null : Short2ObjectOpenCustomHashMap.this.value[this.index].equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return Short2ObjectOpenCustomHashMap.this.strategy.hashCode(Short2ObjectOpenCustomHashMap.this.key[this.index]) ^ (Short2ObjectOpenCustomHashMap.this.value[this.index] == null ? 0 : Short2ObjectOpenCustomHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Short2ObjectOpenCustomHashMap.this.key[this.index] + "=>" + Short2ObjectOpenCustomHashMap.this.value[this.index];
        }
    }
}

