/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpContent
implements Callback,
Closeable {
    private static final Logger LOG = Log.getLogger(HttpContent.class);
    private static final ByteBuffer AFTER = ByteBuffer.allocate(0);
    private final ContentProvider provider;
    private final Iterator<ByteBuffer> iterator;
    private ByteBuffer buffer;
    private volatile ByteBuffer content;

    public HttpContent(ContentProvider provider) {
        this.provider = provider;
        this.iterator = provider == null ? Collections.emptyIterator() : provider.iterator();
    }

    public boolean hasContent() {
        return this.provider != null;
    }

    public boolean isLast() {
        return !this.iterator.hasNext();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public boolean advance() {
        if (this.isLast()) {
            if (this.content != AFTER) {
                this.content = this.buffer = AFTER;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Advanced content past last chunk", new Object[0]);
                }
            }
            return false;
        }
        ByteBuffer buffer = this.buffer = this.iterator.next();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Advanced content to {} chunk {}", new Object[]{this.isLast() ? "last" : "next", buffer});
        }
        this.content = buffer == null ? null : buffer.slice();
        return buffer != null;
    }

    public boolean isConsumed() {
        return this.content == AFTER;
    }

    public void succeeded() {
        if (this.iterator instanceof Callback) {
            ((Callback)this.iterator).succeeded();
        }
    }

    public void failed(Throwable x) {
        if (this.iterator instanceof Callback) {
            ((Callback)this.iterator).failed(x);
        }
    }

    @Override
    public void close() {
        try {
            if (this.iterator instanceof Closeable) {
                ((Closeable)((Object)this.iterator)).close();
            }
        }
        catch (Exception x) {
            LOG.ignore((Throwable)x);
        }
    }

    public String toString() {
        return String.format("%s@%x - has=%b,last=%b,consumed=%b,buffer=%s", this.getClass().getSimpleName(), this.hashCode(), this.hasContent(), this.isLast(), this.isConsumed(), BufferUtil.toDetailString((ByteBuffer)this.getContent()));
    }
}

