/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissObliqueMercator
extends Projection {
    public static final Identifier SOMERC = new Identifier("EPSG", "9815", "Swiss Oblique Mercator", "SOMERC");
    protected final double latc;
    protected final double lonc = this.getCentralMeridian();
    protected final double kc;
    protected final double FE;
    protected final double FN;
    protected final double alpha;
    protected final double b0;
    protected final double K;
    protected final double R;

    public SwissObliqueMercator(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(SOMERC, ellipsoid, parameters);
        this.latc = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        this.kc = this.getScaleFactor();
        double e = ellipsoid.getEccentricity();
        double e2 = ellipsoid.getSquareEccentricity();
        double esin = e * Math.sin(this.latc);
        this.alpha = Math.sqrt(1.0 + e2 * Math.pow(Math.cos(this.latc), 4.0) / (1.0 - e2));
        this.R = ellipsoid.getSemiMajorAxis() * this.kc * Math.sqrt(1.0 - e2) / (1.0 - esin * esin);
        this.b0 = Math.asin(Math.sin(this.latc) / this.alpha);
        this.K = Math.log(Math.tan((1.5707963267948966 + this.b0) / 2.0)) - this.alpha * Math.log(Math.tan((1.5707963267948966 + this.latc) / 2.0)) + this.alpha * e / 2.0 * Math.log((1.0 + e * Math.sin(this.latc)) / (1.0 - e * Math.sin(this.latc)));
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) throws CoordinateDimensionException {
        double e = this.ellipsoid.getEccentricity();
        double S = this.alpha * Math.log(Math.tan((1.5707963267948966 + coord[0]) / 2.0)) - this.alpha * e / 2.0 * Math.log((1.0 + e * Math.sin(coord[0])) / (1.0 - e * Math.sin(coord[0]))) + this.K;
        double b = 2.0 * (Math.atan(Math.exp(S)) - 0.7853981633974483);
        double I = this.alpha * (coord[1] - this.lonc);
        double Ibar = Math.atan(Math.sin(I) / (Math.sin(this.b0) * Math.tan(b) + Math.cos(this.b0) * Math.cos(I)));
        double bbar = Math.asin(Math.cos(this.b0) * Math.sin(b) - Math.sin(this.b0) * Math.cos(b) * Math.cos(I));
        double Y = this.R * Ibar;
        double X = this.R / 2.0 * Math.log((1.0 + Math.sin(bbar)) / (1.0 - Math.sin(bbar)));
        coord[0] = this.FE + Y;
        coord[1] = this.FN + X;
        return coord;
    }

    private double findLatSwissObliqueMercator(double b) {
        int MAXITER = 10;
        double e = this.ellipsoid.getEccentricity();
        double oldLat = 1.0E30;
        double lat = b;
        int iter = 0;
        while (++iter < 10 && Math.abs(lat - oldLat) > 1.0E-15) {
            oldLat = lat;
            double S = (Math.log(Math.tan((1.5707963267948966 + b) / 2.0)) - this.K) / this.alpha + e * Math.log(Math.tan((1.5707963267948966 + Math.asin(e * Math.sin(oldLat))) / 2.0));
            lat = 2.0 * (Math.atan(Math.exp(S)) - 0.7853981633974483);
        }
        if (iter == 10) {
            throw new ArithmeticException("The findLatSwissObliqueMercator method diverges");
        }
        return lat;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new SwissObliqueMercator(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws CoordinateDimensionException {
                double X = coord[1] - this.FN;
                double Y = coord[0] - this.FE;
                double Ibar = Y / this.R;
                double bbar = 2.0 * (Math.atan(Math.exp(X / this.R)) - 0.7853981633974483);
                double b = Math.asin(Math.cos(this.b0) * Math.sin(bbar) + Math.sin(this.b0) * Math.cos(bbar) * Math.cos(Ibar));
                double I = Math.atan(Math.sin(Ibar) / (Math.cos(this.b0) * Math.cos(Ibar) - Math.sin(this.b0) * Math.tan(bbar)));
                coord[1] = this.lonc + I / this.alpha;
                coord[0] = SwissObliqueMercator.this.findLatSwissObliqueMercator(b);
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return SwissObliqueMercator.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return SwissObliqueMercator.this.toString() + " inverse";
            }
        };
    }
}

