/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class UnmodifiableUnionSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = -1937327799873331354L;
    private final Set<E> first;
    private final Set<E> second;

    public UnmodifiableUnionSet(Set<E> first, Set<E> second) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        if (second.size() > first.size()) {
            this.first = second;
            this.second = first;
        } else {
            this.first = first;
            this.second = second;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new UnionIterator();
    }

    @Override
    public int size() {
        int count = this.first.size();
        for (E e : this.second) {
            if (this.first.contains(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        return this.first.contains(o) || this.second.contains(o);
    }

    private class UnionIterator
    implements Iterator<E> {
        private boolean inFirstSet = true;
        private Iterator<E> iterator;
        private E cur;

        public UnionIterator() {
            this.iterator = UnmodifiableUnionSet.this.first.iterator();
            this.cur = this.prefetch();
        }

        @Override
        public boolean hasNext() {
            if (this.cur != null) {
                return true;
            }
            this.cur = this.prefetch();
            return this.cur != null;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.cur;
            this.cur = null;
            return result;
        }

        private E prefetch() {
            block3: {
                Object elem;
                while (true) {
                    if (this.inFirstSet) {
                        if (this.iterator.hasNext()) {
                            return this.iterator.next();
                        }
                        this.inFirstSet = false;
                        this.iterator = UnmodifiableUnionSet.this.second.iterator();
                        continue;
                    }
                    if (!this.iterator.hasNext()) break block3;
                    elem = this.iterator.next();
                    if (!UnmodifiableUnionSet.this.first.contains(elem)) break;
                }
                return elem;
            }
            return null;
        }
    }
}

