/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.traverse.AbstractGraphIterator;

public class RandomWalkIterator<V, E>
extends AbstractGraphIterator<V, E> {
    private V currentVertex;
    private final boolean isWeighted;
    private boolean sinkReached;
    private long maxSteps;
    private Random random;

    public RandomWalkIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex) {
        this(graph, startVertex, true);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex, boolean isWeighted) {
        this(graph, startVertex, isWeighted, Long.MAX_VALUE);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex, boolean isWeighted, long maxSteps) {
        this(graph, startVertex, isWeighted, maxSteps, new Random());
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex, boolean isWeighted, long maxSteps, Random rng) {
        super(graph);
        this.crossComponentTraversal = false;
        this.isWeighted = isWeighted;
        this.maxSteps = maxSteps;
        if (startVertex == null) {
            if (graph.vertexSet().size() > 0) {
                this.currentVertex = graph.vertexSet().iterator().next();
            }
        } else if (graph.containsVertex(startVertex)) {
            this.currentVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
        this.sinkReached = false;
        this.random = Objects.requireNonNull(rng, "Random number generator cannot be null");
    }

    protected boolean isExhausted() {
        return this.maxSteps == 0L;
    }

    protected void encounterVertex(V vertex, E edge) {
        --this.maxSteps;
    }

    @Override
    public boolean hasNext() {
        return this.currentVertex != null && !this.isExhausted() && !this.sinkReached;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Set potentialEdges = this.graph.outgoingEdgesOf(this.currentVertex);
        Object nextEdge = this.drawEdge(potentialEdges);
        if (nextEdge != null) {
            V nextVertex = Graphs.getOppositeVertex(this.graph, nextEdge, this.currentVertex);
            this.encounterVertex(nextVertex, nextEdge);
            this.fireEdgeTraversed(this.createEdgeTraversalEvent(nextEdge));
            this.fireVertexTraversed(this.createVertexTraversalEvent(nextVertex));
            this.currentVertex = nextVertex;
            return nextVertex;
        }
        this.sinkReached = true;
        return this.currentVertex;
    }

    private E drawEdge(Set<? extends E> edges) {
        int drawn;
        if (edges.isEmpty()) {
            return null;
        }
        ArrayList<E> list = new ArrayList<E>(edges);
        if (this.isWeighted) {
            Iterator safeIter = list.iterator();
            double border = this.random.nextDouble() * this.getTotalWeight(list);
            double d = 0.0;
            drawn = -1;
            do {
                ++drawn;
            } while ((d += this.graph.getEdgeWeight(safeIter.next())) < border);
        } else {
            drawn = this.random.nextInt(list.size());
        }
        return list.get(drawn);
    }

    private double getTotalWeight(Collection<E> edges) {
        double total = 0.0;
        for (E e : edges) {
            total += this.graph.getEdgeWeight(e);
        }
        return total;
    }
}

