/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql.ast;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.parser.sparql.ast.Node;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilderTreeConstants;
import org.openrdf.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import org.openrdf.query.parser.sparql.ast.VisitorException;

public class SimpleNode
implements Node {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Node parent;
    protected List<Node> children;
    protected int id;
    protected SyntaxTreeBuilder parser;

    public SimpleNode(int id) {
        this.id = id;
        this.children = new ArrayList<Node>();
    }

    public SimpleNode(SyntaxTreeBuilder parser, int id) {
        this(id);
        this.parser = parser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        while (i >= this.children.size()) {
            this.children.add(null);
        }
        this.children.set(i, n);
    }

    @Override
    public void jjtAppendChild(Node n) {
        this.children.add(n);
    }

    @Override
    public void jjtInsertChild(Node n, int i) {
        this.children.add(i, n);
    }

    @Override
    public void jjtReplaceChild(Node oldNode, Node newNode) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != oldNode) continue;
            this.children.set(i, newNode);
        }
    }

    public void jjtReplaceWith(Node newNode) {
        if (this.parent != null) {
            this.parent.jjtReplaceChild(this, newNode);
        }
        for (Node childNode : this.children) {
            childNode.jjtSetParent(newNode);
        }
    }

    public List<Node> jjtGetChildren() {
        return this.children;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children.get(i);
    }

    public <T extends Node> T jjtGetChild(Class<T> type) {
        for (Node n : this.children) {
            if (!type.isInstance(n)) continue;
            return (T)n;
        }
        return null;
    }

    public <T extends Node> List<T> jjtGetChildren(Class<T> type) {
        ArrayList<Node> result = new ArrayList<Node>(this.children.size());
        for (Node n : this.children) {
            if (!type.isInstance(n)) continue;
            result.add(n);
        }
        return result;
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children.size();
    }

    @Override
    public Object jjtAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        for (Node childNode : this.children) {
            data = childNode.jjtAccept(visitor, data);
        }
        return data;
    }

    public String toString() {
        return SyntaxTreeBuilderTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix, Appendable out) throws IOException {
        out.append(prefix).append(this.toString());
        for (Node childNode : this.children) {
            if (childNode == null) continue;
            out.append(LINE_SEPARATOR);
            ((SimpleNode)childNode).dump(prefix + " ", out);
        }
    }

    public String dump(String prefix) {
        StringWriter out = new StringWriter(256);
        try {
            this.dump(prefix, out);
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error while writing to StringWriter", e);
        }
    }
}

