/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.LockManager;
import info.aduna.concurrent.locks.Properties;
import info.aduna.concurrent.locks.ReadWriteLockManager;

public abstract class AbstractReadWriteLockManager
implements ReadWriteLockManager {
    private final LockManager activeWriter;
    private final LockManager activeReaders;

    public AbstractReadWriteLockManager() {
        this(false);
    }

    public AbstractReadWriteLockManager(boolean trackLocks) {
        boolean trace = trackLocks || Properties.lockTrackingEnabled();
        this.activeWriter = new LockManager(trace);
        this.activeReaders = new LockManager(trace);
    }

    protected boolean isWriterActive() {
        return this.activeWriter.isActiveLock();
    }

    protected boolean isReaderActive() {
        return this.activeReaders.isActiveLock();
    }

    protected void waitForActiveWriter() throws InterruptedException {
        this.activeWriter.waitForActiveLocks();
    }

    protected void waitForActiveReaders() throws InterruptedException {
        this.activeReaders.waitForActiveLocks();
    }

    protected Lock createReadLock() {
        return this.activeReaders.createLock("Read");
    }

    protected Lock createWriteLock() {
        return this.activeWriter.createLock("Write");
    }
}

