/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.engine.RandomEngine;
import cern.jet.stat.Probability;

public class Poisson
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double my_old = -1.0;
    protected double p;
    protected double q;
    protected double p0;
    protected double[] pp = new double[36];
    protected int llll;
    protected double my_last = -1.0;
    protected double ll;
    protected int k2;
    protected int k4;
    protected int k1;
    protected int k5;
    protected double dl;
    protected double dr;
    protected double r1;
    protected double r2;
    protected double r4;
    protected double r5;
    protected double lr;
    protected double l_my;
    protected double c_pm;
    protected double f1;
    protected double f2;
    protected double f4;
    protected double f5;
    protected double p1;
    protected double p2;
    protected double p3;
    protected double p4;
    protected double p5;
    protected double p6;
    protected int m;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 10.0;
    protected static Poisson shared = new Poisson(0.0, Poisson.makeDefaultGenerator());

    public Poisson(double mean, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setMean(mean);
    }

    public double cdf(int k) {
        return Probability.poisson(k, this.mean);
    }

    @Override
    public Object clone() {
        Poisson copy = (Poisson)super.clone();
        if (this.pp != null) {
            copy.pp = (double[])this.pp.clone();
        }
        return copy;
    }

    private static double f(int k, double l_nu, double c_pm) {
        return Math.exp((double)k * l_nu - Arithmetic.logFactorial(k) - c_pm);
    }

    @Override
    public int nextInt() {
        return this.nextInt(this.mean);
    }

    public int nextInt(double theMean) {
        RandomEngine gen = this.randomGenerator;
        double my = theMean;
        if (my < 10.0) {
            if (my != this.my_old) {
                this.my_old = my;
                this.llll = 0;
                this.q = this.p = Math.exp(-my);
                this.p0 = this.p;
            }
            this.m = my > 1.0 ? (int)my : 1;
            while (true) {
                double u = gen.raw();
                int k = 0;
                if (u <= this.p0) {
                    return k;
                }
                if (this.llll != 0) {
                    int i;
                    for (k = i = u > 0.458 ? Math.min(this.llll, this.m) : 1; k <= this.llll; ++k) {
                        if (!(u <= this.pp[k])) continue;
                        return k;
                    }
                    if (this.llll == 35) continue;
                }
                for (k = this.llll + 1; k <= 35; ++k) {
                    this.p *= my / (double)k;
                    this.q += this.p;
                    this.pp[k] = this.q;
                    if (!(u <= this.q)) continue;
                    this.llll = k;
                    return k;
                }
                this.llll = 35;
            }
        }
        if (my < 2.147483647E9) {
            int X;
            this.m = (int)my;
            if (my != this.my_last) {
                this.my_last = my;
                double Ds = Math.sqrt(my + 0.25);
                this.k2 = (int)Math.ceil(my - 0.5 - Ds);
                this.k4 = (int)(my - 0.5 + Ds);
                this.k1 = this.k2 + this.k2 - this.m + 1;
                this.k5 = this.k4 + this.k4 - this.m;
                this.dl = this.k2 - this.k1;
                this.dr = this.k5 - this.k4;
                this.r1 = my / (double)this.k1;
                this.r2 = my / (double)this.k2;
                this.r4 = my / (double)(this.k4 + 1);
                this.r5 = my / (double)(this.k5 + 1);
                this.ll = Math.log(this.r1);
                this.lr = -Math.log(this.r5);
                this.l_my = Math.log(my);
                this.c_pm = (double)this.m * this.l_my - Arithmetic.logFactorial(this.m);
                this.f2 = Poisson.f(this.k2, this.l_my, this.c_pm);
                this.f4 = Poisson.f(this.k4, this.l_my, this.c_pm);
                this.f1 = Poisson.f(this.k1, this.l_my, this.c_pm);
                this.f5 = Poisson.f(this.k5, this.l_my, this.c_pm);
                this.p1 = this.f2 * (this.dl + 1.0);
                this.p2 = this.f2 * this.dl + this.p1;
                this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
                this.p4 = this.f4 * this.dr + this.p3;
                this.p5 = this.f1 / this.ll + this.p4;
                this.p6 = this.f5 / this.lr + this.p5;
            }
            while (true) {
                int Y;
                int Dk;
                double W;
                double V;
                double d;
                double U = gen.raw() * this.p6;
                if (d < this.p2) {
                    double d2;
                    double d3;
                    double d4;
                    V = U - this.p1;
                    if (d4 < 0.0) {
                        return this.k2 + (int)(U / this.f2);
                    }
                    W = V / this.dl;
                    if (d3 < this.f1) {
                        return this.k1 + (int)(V / this.f1);
                    }
                    Dk = (int)(this.dl * gen.raw()) + 1;
                    if (W <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - Dk;
                    }
                    V = this.f2 + this.f2 - W;
                    if (d2 < 1.0) {
                        Y = this.k2 + Dk;
                        if (V <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return Y;
                        }
                        if (V <= Poisson.f(Y, this.l_my, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k2 - Dk;
                } else if (U < this.p4) {
                    double d5;
                    double d6;
                    double d7;
                    V = U - this.p3;
                    if (d7 < 0.0) {
                        return this.k4 - (int)((U - this.p2) / this.f4);
                    }
                    W = V / this.dr;
                    if (d6 < this.f5) {
                        return this.k5 - (int)(V / this.f5);
                    }
                    Dk = (int)(this.dr * gen.raw()) + 1;
                    if (W <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + Dk;
                    }
                    V = this.f4 + this.f4 - W;
                    if (d5 < 1.0) {
                        Y = this.k4 - Dk;
                        if (V <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                            return Y;
                        }
                        if (V <= Poisson.f(Y, this.l_my, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k4 + Dk;
                } else {
                    W = gen.raw();
                    if (U < this.p5) {
                        Dk = (int)(1.0 - Math.log(W) / this.ll);
                        X = this.k1 - Dk;
                        if (X < 0) continue;
                        if ((W *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                            return X;
                        }
                    } else {
                        Dk = (int)(1.0 - Math.log(W) / this.lr);
                        X = this.k5 + Dk;
                        if ((W *= (U - this.p5) * this.lr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                            return X;
                        }
                    }
                }
                if (Math.log(W) <= (double)X * this.l_my - Arithmetic.logFactorial(X) - this.c_pm) break;
            }
            return X;
        }
        return (int)my;
    }

    public double pdf(int k) {
        return Math.exp((double)k * Math.log(this.mean) - Arithmetic.logFactorial(k) - this.mean);
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int staticNextInt(double mean) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setMean(mean);
            return shared.nextInt();
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomGenerator) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

