/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleFunction;
import cern.colt.function.IntFunction;
import cern.jet.random.engine.RandomEngine;

public abstract class AbstractDistribution
extends PersistentObject
implements DoubleFunction,
IntFunction {
    protected RandomEngine randomGenerator;

    protected AbstractDistribution() {
    }

    @Override
    public double apply(double dummy) {
        return this.nextDouble();
    }

    @Override
    public int apply(int dummy) {
        return this.nextInt();
    }

    @Override
    public Object clone() {
        AbstractDistribution copy = (AbstractDistribution)super.clone();
        if (this.randomGenerator != null) {
            copy.randomGenerator = (RandomEngine)this.randomGenerator.clone();
        }
        return copy;
    }

    protected RandomEngine getRandomGenerator() {
        return this.randomGenerator;
    }

    public static RandomEngine makeDefaultGenerator() {
        return RandomEngine.makeDefault();
    }

    public abstract double nextDouble();

    public int nextInt() {
        return (int)Math.round(this.nextDouble());
    }

    protected void setRandomGenerator(RandomEngine randomGenerator) {
        this.randomGenerator = randomGenerator;
    }
}

