/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.map.OpenIntObjectHashMap;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SelectedSparseObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix1D;

public class SparseObjectMatrix2D
extends ObjectMatrix2D {
    protected AbstractIntObjectMap elements;

    public SparseObjectMatrix2D(Object[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseObjectMatrix2D(int rows, int columns) {
        this(rows, columns, rows * (columns / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix2D(int rows, int columns, int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(rows, columns);
        this.elements = new OpenIntObjectHashMap(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    protected SparseObjectMatrix2D(int rows, int columns, AbstractIntObjectMap elements, int rowZero, int columnZero, int rowStride, int columnStride) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = false;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements.ensureCapacity(minCapacity);
    }

    @Override
    public Object getQuick(int row, int column) {
        return this.elements.get(this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride);
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D otherMatrix = (SelectedSparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D otherMatrix = (SparseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new SparseObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new SparseObjectMatrix1D(size);
    }

    @Override
    protected ObjectMatrix1D like1D(int size, int offset, int stride) {
        return new SparseObjectMatrix1D(size, this.elements, offset, stride);
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        int index = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        if (value == null) {
            this.elements.removeKey(index);
        } else {
            this.elements.put(index, value);
        }
    }

    @Override
    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedSparseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

