/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.function.Double27Function;
import cern.colt.function.Double9Function;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix2DProcedure;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.DoubleMatrix3DProcedure;

public class Stencil {
    protected Stencil() {
    }

    public static int stencil27(DoubleMatrix3D A, Double27Function function, int maxIterations, DoubleMatrix3DProcedure hasConverged, int convergenceIterations) {
        DoubleMatrix3D B = A.copy();
        if (convergenceIterations <= 1) {
            convergenceIterations = 2;
        }
        if (convergenceIterations % 2 != 0) {
            ++convergenceIterations;
        }
        int i = 0;
        while (i < maxIterations) {
            A.zAssign27Neighbors(B, function);
            B.zAssign27Neighbors(A, function);
            if ((i += 2) % convergenceIterations != 0 || hasConverged == null || !hasConverged.apply(A)) continue;
            return i;
        }
        return i;
    }

    public static int stencil9(DoubleMatrix2D A, Double9Function function, int maxIterations, DoubleMatrix2DProcedure hasConverged, int convergenceIterations) {
        DoubleMatrix2D B = A.copy();
        if (convergenceIterations <= 1) {
            convergenceIterations = 2;
        }
        if (convergenceIterations % 2 != 0) {
            ++convergenceIterations;
        }
        int i = 0;
        while (i < maxIterations) {
            A.zAssign8Neighbors(B, function);
            B.zAssign8Neighbors(A, function);
            if ((i += 2) % convergenceIterations != 0 || hasConverged == null || !hasConverged.apply(A)) continue;
            return i;
        }
        return i;
    }
}

