/*
 * Decompiled with CFR 0.152.
 */
package cutthecrap.utils.striterators;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    private final T[] m_src;
    private int m_index;
    private final int m_last;

    public ArrayIterator(T[] src) {
        this(src, 0, src.length);
    }

    public ArrayIterator(T[] src, int off, int len) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        if (off + len > src.length) {
            throw new IllegalArgumentException();
        }
        this.m_src = src;
        this.m_index = off;
        this.m_last = off + len;
    }

    @Override
    public boolean hasNext() {
        return this.m_last > this.m_index;
    }

    @Override
    public T next() {
        if (this.m_index < this.m_last) {
            return this.m_src[this.m_index++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
    }
}

