import { IResource, Resource } from '@aws-cdk/core';
import { IAlarmAction } from './alarm-action';
/**
 * Interface for Alarm Rule.
 *
 * @stability stable
 */
export interface IAlarmRule {
    /**
     * serialized representation of Alarm Rule to be used when building the Composite Alarm resource.
     *
     * @stability stable
     */
    renderAlarmRule(): string;
}
/**
 * Represents a CloudWatch Alarm.
 *
 * @stability stable
 */
export interface IAlarm extends IAlarmRule, IResource {
    /**
     * Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo).
     *
     * @stability stable
     * @attribute true
     */
    readonly alarmArn: string;
    /**
     * Name of the alarm.
     *
     * @stability stable
     * @attribute true
     */
    readonly alarmName: string;
}
/**
 * The base class for Alarm and CompositeAlarm resources.
 *
 * @stability stable
 */
export declare abstract class AlarmBase extends Resource implements IAlarm {
    /**
     * Alarm ARN (i.e. arn:aws:cloudwatch:<region>:<account-id>:alarm:Foo).
     *
     * @stability stable
     * @attribute true
     */
    abstract readonly alarmArn: string;
    /**
     * Name of the alarm.
     *
     * @stability stable
     */
    abstract readonly alarmName: string;
    /**
     * @stability stable
     */
    protected alarmActionArns?: string[];
    /**
     * @stability stable
     */
    protected insufficientDataActionArns?: string[];
    /**
     * @stability stable
     */
    protected okActionArns?: string[];
    /**
     * AlarmRule indicating ALARM state for Alarm.
     *
     * @stability stable
     */
    renderAlarmRule(): string;
    /**
     * Trigger this action if the alarm fires.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @stability stable
     */
    addAlarmAction(...actions: IAlarmAction[]): void;
    /**
     * Trigger this action if there is insufficient data to evaluate the alarm.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @stability stable
     */
    addInsufficientDataAction(...actions: IAlarmAction[]): void;
    /**
     * Trigger this action if the alarm returns from breaching state into ok state.
     *
     * Typically the ARN of an SNS topic or ARN of an AutoScaling policy.
     *
     * @stability stable
     */
    addOkAction(...actions: IAlarmAction[]): void;
}
